/*
 * Decompiled with CFR 0.152.
 */
package processing.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import processing.io.NativeInterface;

public class I2C {
    protected String dev;
    protected int handle;
    protected int slave;
    protected byte[] out;
    protected boolean transmitting;

    public I2C(String string) {
        NativeInterface.loadLibrary();
        this.dev = string;
        if (NativeInterface.isSimulated()) {
            return;
        }
        this.handle = NativeInterface.openDevice("/dev/" + string);
        if (this.handle < 0) {
            throw new RuntimeException(NativeInterface.getError(this.handle));
        }
    }

    public void beginTransmission(int n) {
        if (120 <= n) {
            System.err.println("beginTransmission expects a 7 bit address, try shifting one bit to the right");
            throw new IllegalArgumentException("Illegal address");
        }
        this.slave = n;
        this.transmitting = true;
        this.out = null;
    }

    public void close() {
        if (NativeInterface.isSimulated()) {
            return;
        }
        NativeInterface.closeDevice(this.handle);
        this.handle = 0;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public void endTransmission() {
        if (!this.transmitting) {
            return;
        }
        if (NativeInterface.isSimulated()) {
            return;
        }
        int n = NativeInterface.transferI2c(this.handle, this.slave, this.out, null);
        this.transmitting = false;
        this.out = null;
        if (n < 0) {
            if (n == -5 | n == -121) {
                System.err.println("The device did not respond. Check the cabling and whether you are using the correct address.");
            }
            throw new RuntimeException(NativeInterface.getError(n));
        }
    }

    public static String[] list() {
        if (NativeInterface.isSimulated()) {
            return new String[]{"i2c-1"};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File("/dev");
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (!file2.getName().startsWith("i2c-")) continue;
                arrayList.add(file2.getName());
            }
        }
        Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public byte[] read(int n) {
        if (!this.transmitting) {
            throw new RuntimeException("beginTransmisson has not been called");
        }
        byte[] byArray = new byte[n];
        if (NativeInterface.isSimulated()) {
            return byArray;
        }
        int n2 = NativeInterface.transferI2c(this.handle, this.slave, this.out, byArray);
        this.transmitting = false;
        this.out = null;
        if (n2 < 0) {
            if (n2 == -5 | n2 == -121) {
                System.err.println("The device did not respond. Check the cabling and whether you are using the correct address.");
            }
            throw new RuntimeException(NativeInterface.getError(n2));
        }
        return byArray;
    }

    public void write(byte[] byArray) {
        if (!this.transmitting) {
            throw new RuntimeException("beginTransmisson has not been called");
        }
        if (this.out == null) {
            this.out = byArray;
        } else {
            byte[] byArray2 = new byte[this.out.length + byArray.length];
            System.arraycopy(this.out, 0, byArray2, 0, this.out.length);
            System.arraycopy(byArray, 0, byArray2, this.out.length, byArray.length);
            this.out = byArray2;
        }
    }

    public void write(String string) {
        this.write(string.getBytes());
    }

    public void write(int n) {
        if (n < -128 || 255 < n) {
            System.err.println("The write function can only operate on a single byte at a time. Call it with a value from 0 to 255, or -128 to 127.");
            throw new RuntimeException("Argument does not fit into a single byte");
        }
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray);
    }

    public void write(byte by) {
        this.write(by & 0xFF);
    }
}

