/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.compottie.internal.animation.expressions;

import androidx.compose.runtime.internal.StabilityInferred;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.EvaluationContext;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.Expression;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.ExpressionContext;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.ExpressionInterpreter;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.ExpressionInterpreterImpl;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.ExpressionInterpreterImplKt;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.ExpressionKt;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.LogicalContext;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.NumberFormat;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.Undefined;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.VariableType;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.OpGlobalContext;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.OpUtilKt;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.js.JsContext;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.keywords.FunctionParam;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.keywords.OpBlock;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.keywords.OpBooleansKt;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.keywords.OpEqualsKt;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.keywords.OpFunction;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.keywords.OpFunctionKt;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.keywords.OpIfCondition;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.keywords.OpLoopsKt;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.keywords.OpReturn;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.keywords.OpTryCatchKt;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.math.OpAddKt;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.math.OpDivKt;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.math.OpIncrementKt;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.math.OpModKt;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.math.OpMulKt;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.math.OpSubKt;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.math.OpUnaryKt;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.value.OpAssign;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.value.OpAssignByIndex;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.value.OpCompareKt;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.value.OpConstantKt;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.value.OpGetVariable;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.value.OpIndex;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.value.OpMakeArrayKt;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.value.OpVar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\t\b\u0001\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u000bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u001c\u0010\u0016\u001a\u00020\u00132\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00130\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\rH\u0002J.\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u001c\b\u0002\u0010\u001f\u001a\u0016\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!\u0018\u00010 H\u0002J\u001c\u0010\"\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\r2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$H\u0002J\u0010\u0010%\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\rH\u0002J\u0010\u0010&\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\rH\u0002J\f\u0010'\u001a\u00020\r*\u00020\rH\u0002J\u001a\u0010(\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0002J\u001a\u0010+\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\r2\b\u0010,\u001a\u0004\u0018\u00010\u0003H\u0002J\b\u0010-\u001a\u00020\rH\u0002J\b\u0010.\u001a\u00020\rH\u0002J\u001c\u0010/\u001a\u00020\r2\b\b\u0002\u00100\u001a\u00020\u00132\b\b\u0002\u00101\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lio/github/alexzhirkevich/compottie/internal/animation/expressions/ExpressionInterpreterImpl;", "Lio/github/alexzhirkevich/compottie/internal/animation/expressions/ExpressionInterpreter;", "expr", "", "context", "Lio/github/alexzhirkevich/compottie/internal/animation/expressions/EvaluationContext;", "<init>", "(Ljava/lang/String;Lio/github/alexzhirkevich/compottie/internal/animation/expressions/EvaluationContext;)V", "pos", "", "ch", "", "interpret", "Lio/github/alexzhirkevich/compottie/internal/animation/expressions/Expression;", "prepareNextChar", "", "nextChar", "prevChar", "skip", "", "eat", "charToEat", "nextCharIs", "condition", "Lkotlin/Function1;", "eatSequence", "seq", "nextSequenceIs", "parseAssignment", "parseAssignmentValue", "x", "merge", "Lkotlin/Function2;", "", "parseExpressionOp", "logicalContext", "Lio/github/alexzhirkevich/compottie/internal/animation/expressions/LogicalContext;", "parseTermOp", "parseFactorOp", "finish", "parseFunctionArgs", "", "name", "parseFunction", "func", "parseWhileCondition", "parseFunctionDefinition", "parseBlock", "scoped", "requireBlock", "compottie"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nExpressionInterpreterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpressionInterpreterImpl.kt\nio/github/alexzhirkevich/compottie/internal/animation/expressions/ExpressionInterpreterImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,725:1\n1#2:726\n151#3,3:727\n33#3,4:730\n154#3,2:734\n38#3:736\n156#3:737\n*S KotlinDebug\n*F\n+ 1 ExpressionInterpreterImpl.kt\nio/github/alexzhirkevich/compottie/internal/animation/expressions/ExpressionInterpreterImpl\n*L\n618#1:727,3\n618#1:730,4\n618#1:734,2\n618#1:736\n618#1:737\n*E\n"})
public final class ExpressionInterpreterImpl
implements ExpressionInterpreter {
    @NotNull
    private final String expr;
    @NotNull
    private final EvaluationContext context;
    private int pos;
    private char ch;
    public static final int $stable = 8;

    public ExpressionInterpreterImpl(@NotNull String expr, @NotNull EvaluationContext context) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.expr = expr;
        this.context = context;
        this.pos = -1;
        this.ch = (char)32;
    }

    @Override
    @NotNull
    public Expression interpret() {
        Object object = CollectionsKt.createListBuilder();
        List $this$interpret_u24lambda_u241 = object;
        boolean bl = false;
        this.pos = -1;
        this.ch = (char)32;
        if (ExpressionKt.getEXPR_DEBUG_PRINT_ENABLED()) {
            System.out.println((Object)("Parsing " + this.expr));
        }
        this.nextChar();
        Expression x = null;
        while (true) {
            if (this.eat(';')) {
                continue;
            }
            if (this.pos >= this.expr.length()) break;
            x = this.parseAssignment(x instanceof ExpressionContext ? (ExpressionContext)x : (ExpressionContext)OpGlobalContext.INSTANCE);
            $this$interpret_u24lambda_u241.add(x);
            if (this.pos >= this.expr.length()) break;
        }
        if (!(this.pos <= this.expr.length())) {
            boolean bl2 = false;
            String string = "Unexpected Lottie expression " + this.expr;
            throw new IllegalArgumentException(string.toString());
        }
        List expressions = CollectionsKt.build((List)object);
        Object it = object = new OpBlock(expressions, false);
        boolean bl3 = false;
        this.pos = -1;
        this.ch = (char)32;
        if (ExpressionKt.getEXPR_DEBUG_PRINT_ENABLED()) {
            System.out.println((Object)("Expression parsed: " + this.expr));
        }
        return (Expression)object;
    }

    private final void prepareNextChar() {
        while (this.skip(this.ch) && this.pos < this.expr.length()) {
            this.nextChar();
        }
    }

    private final void nextChar() {
        ++this.pos;
        this.ch = (char)(this.pos < this.expr.length() ? (int)this.expr.charAt(this.pos) : 32);
    }

    private final void prevChar() {
        this.pos += -1;
        this.ch = (char)(this.pos > 0 && this.pos < this.expr.length() ? (int)this.expr.charAt(this.pos) : 32);
    }

    private final boolean skip(char $this$skip) {
        return $this$skip == ' ' || $this$skip == '\n';
    }

    private final boolean eat(char charToEat) {
        while (this.skip(this.ch) && this.pos < this.expr.length()) {
            this.nextChar();
        }
        if (this.ch == charToEat) {
            this.nextChar();
            return true;
        }
        return false;
    }

    private final boolean nextCharIs(Function1<? super Character, Boolean> condition) {
        for (int i = this.pos; i < this.expr.length(); ++i) {
            if (((Boolean)condition.invoke((Object)Character.valueOf(this.expr.charAt(i)))).booleanValue()) {
                return true;
            }
            if (this.skip(this.expr.charAt(i))) {
                continue;
            }
            return false;
        }
        return false;
    }

    private final boolean eatSequence(String seq) {
        boolean bl;
        int p = this.pos;
        char c = this.ch;
        if (((CharSequence)seq).length() == 0) {
            return true;
        }
        if (!this.eat(seq.charAt(0))) {
            return false;
        }
        if (StringsKt.indexOf$default((CharSequence)this.expr, (String)seq, (int)(this.pos - 1), (boolean)false, (int)4, null) == this.pos - 1) {
            this.pos += seq.length() - 1;
            this.ch = this.expr.charAt(RangesKt.coerceIn((int)this.pos, (ClosedRange)((ClosedRange)StringsKt.getIndices((CharSequence)this.expr))));
            bl = true;
        } else {
            this.pos = p;
            this.ch = c;
            bl = false;
        }
        return bl;
    }

    private final boolean nextSequenceIs(String seq) {
        boolean bl;
        int p = this.pos;
        char c = this.ch;
        if (((CharSequence)seq).length() == 0) {
            return true;
        }
        if (!this.eat(seq.charAt(0))) {
            return false;
        }
        if (StringsKt.indexOf$default((CharSequence)this.expr, (String)seq, (int)(this.pos - 1), (boolean)false, (int)4, null) == this.pos - 1) {
            this.pos = p;
            this.ch = c;
            bl = true;
        } else {
            this.pos = p;
            this.ch = c;
            bl = false;
        }
        return bl;
    }

    private final Expression parseAssignment(Expression context) {
        Expression x = ExpressionInterpreterImpl.parseExpressionOp$default(this, context, null, 2, null);
        if (ExpressionKt.getEXPR_DEBUG_PRINT_ENABLED()) {
            System.out.println((Object)("Parsing assignment for " + x));
        }
        while (true) {
            Expression expression;
            this.prepareNextChar();
            if (this.eatSequence("+=")) {
                expression = this.parseAssignmentValue(x, (Function2<Object, Object, ? extends Object>)((Function2)parseAssignment.1.INSTANCE));
            } else if (this.eatSequence("-=")) {
                expression = this.parseAssignmentValue(x, (Function2<Object, Object, ? extends Object>)((Function2)parseAssignment.2.INSTANCE));
            } else if (this.eatSequence("*=")) {
                expression = this.parseAssignmentValue(x, (Function2<Object, Object, ? extends Object>)((Function2)parseAssignment.3.INSTANCE));
            } else if (this.eatSequence("/=")) {
                expression = this.parseAssignmentValue(x, (Function2<Object, Object, ? extends Object>)((Function2)parseAssignment.4.INSTANCE));
            } else if (this.eatSequence("%=")) {
                expression = this.parseAssignmentValue(x, (Function2<Object, Object, ? extends Object>)((Function2)parseAssignment.5.INSTANCE));
            } else if (this.eat('=')) {
                expression = this.parseAssignmentValue(x, null);
            } else if (OpIncrementKt.isAssignable(x) && this.eatSequence("++")) {
                expression = OpIncrementKt.OpIncrement(x);
            } else if (OpIncrementKt.isAssignable(x) && this.eatSequence("--")) {
                expression = OpIncrementKt.OpDecrement(x);
            } else {
                return x;
            }
            x = expression;
        }
    }

    private final Expression parseAssignmentValue(Expression x, Function2<Object, Object, ? extends Object> merge) {
        Expression expression;
        if (x instanceof OpIndex && ((OpIndex)x).getVariable() instanceof OpGetVariable) {
            OpAssignByIndex opAssignByIndex;
            OpAssignByIndex it = opAssignByIndex = new OpAssignByIndex(((OpGetVariable)((OpIndex)x).getVariable()).getName(), ((OpGetVariable)((OpIndex)x).getVariable()).getAssignmentType(), ((OpIndex)x).getIndex(), this.parseAssignment(OpGlobalContext.INSTANCE), merge);
            boolean bl = false;
            if (ExpressionKt.getEXPR_DEBUG_PRINT_ENABLED()) {
                System.out.println((Object)("parsing assignment with index for " + ((OpGetVariable)((OpIndex)x).getVariable()).getName()));
            }
            expression = opAssignByIndex;
        } else if (x instanceof OpGetVariable) {
            Object object = ((OpGetVariable)x).getName();
            Object it = this.parseAssignment(OpGlobalContext.INSTANCE);
            VariableType bl = ((OpGetVariable)x).getAssignmentType();
            it = object = new OpAssign(bl, (String)object, (Expression)it, merge);
            boolean bl2 = false;
            if (ExpressionKt.getEXPR_DEBUG_PRINT_ENABLED()) {
                System.out.println((Object)("parsing assignment for " + ((OpGetVariable)x).getName() + " in " + ((OpAssign)it).getType() + " scope"));
            }
            expression = (Expression)object;
        } else {
            throw new IllegalStateException("Invalid assignment".toString());
        }
        return expression;
    }

    static /* synthetic */ Expression parseAssignmentValue$default(ExpressionInterpreterImpl expressionInterpreterImpl, Expression expression, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = null;
        }
        return expressionInterpreterImpl.parseAssignmentValue(expression, (Function2<Object, Object, ? extends Object>)function2);
    }

    private final Expression parseExpressionOp(Expression context, LogicalContext logicalContext) {
        Expression x = this.parseTermOp(context);
        while (true) {
            Expression expression;
            this.prepareNextChar();
            if (logicalContext != LogicalContext.Compare && this.eatSequence("&&")) {
                expression = OpBooleansKt.OpBoolean(this.parseExpressionOp(OpGlobalContext.INSTANCE, LogicalContext.And), x, (Function2<? super Boolean, ? super Boolean, Boolean>)((Function2)parseExpressionOp.1.INSTANCE));
            } else if (logicalContext == null && this.eatSequence("||")) {
                expression = OpBooleansKt.OpBoolean(this.parseExpressionOp(OpGlobalContext.INSTANCE, LogicalContext.Or), x, (Function2<? super Boolean, ? super Boolean, Boolean>)((Function2)parseExpressionOp.2.INSTANCE));
            } else if (this.eatSequence("<=")) {
                expression = OpCompareKt.OpCompare(x, this.parseExpressionOp(OpGlobalContext.INSTANCE, LogicalContext.Compare), ExpressionInterpreterImpl::parseExpressionOp$lambda$5);
            } else if (this.eatSequence("<")) {
                expression = OpCompareKt.OpCompare(x, this.parseExpressionOp(OpGlobalContext.INSTANCE, LogicalContext.Compare), OpCompareKt.getOpLessComparator());
            } else if (this.eatSequence(">=")) {
                expression = OpCompareKt.OpCompare(x, this.parseExpressionOp(OpGlobalContext.INSTANCE, LogicalContext.Compare), ExpressionInterpreterImpl::parseExpressionOp$lambda$6);
            } else if (this.eatSequence(">")) {
                expression = OpCompareKt.OpCompare(x, this.parseExpressionOp(OpGlobalContext.INSTANCE, LogicalContext.Compare), OpCompareKt.getOpGreaterComparator());
            } else if (this.eatSequence("===")) {
                expression = OpEqualsKt.OpEquals(x, this.parseExpressionOp(OpGlobalContext.INSTANCE, LogicalContext.Compare), true);
            } else if (this.eatSequence("==")) {
                expression = OpEqualsKt.OpEquals(x, this.parseExpressionOp(OpGlobalContext.INSTANCE, LogicalContext.Compare), false);
            } else if (this.eatSequence("!==")) {
                expression = OpBooleansKt.OpNot(OpEqualsKt.OpEquals(x, this.parseExpressionOp(OpGlobalContext.INSTANCE, LogicalContext.Compare), false));
            } else if (this.eatSequence("!=")) {
                expression = OpBooleansKt.OpNot(OpEqualsKt.OpEquals(x, this.parseExpressionOp(OpGlobalContext.INSTANCE, LogicalContext.Compare), true));
            } else if (!this.nextSequenceIs("++") && !this.nextSequenceIs("+=") && this.eat('+')) {
                expression = OpAddKt.OpAdd(x, this.parseTermOp(OpGlobalContext.INSTANCE));
            } else if (!this.nextSequenceIs("--") && !this.nextSequenceIs("-=") && this.eat('-')) {
                expression = OpSubKt.OpSub(x, this.parseTermOp(OpGlobalContext.INSTANCE));
            } else {
                return x;
            }
            x = expression;
        }
    }

    static /* synthetic */ Expression parseExpressionOp$default(ExpressionInterpreterImpl expressionInterpreterImpl, Expression expression, LogicalContext logicalContext, int n, Object object) {
        if ((n & 2) != 0) {
            logicalContext = null;
        }
        return expressionInterpreterImpl.parseExpressionOp(expression, logicalContext);
    }

    private final Expression parseTermOp(Expression context) {
        Expression x = this.parseFactorOp(context);
        while (true) {
            Expression expression;
            this.prepareNextChar();
            if (!this.nextSequenceIs("*=") && this.eat('*')) {
                expression = OpMulKt.OpMul(x, this.parseFactorOp(OpGlobalContext.INSTANCE));
            } else if (!this.nextSequenceIs("/=") && this.eat('/')) {
                expression = OpDivKt.OpDiv(x, this.parseFactorOp(OpGlobalContext.INSTANCE));
            } else if (!this.nextSequenceIs("%=") && this.eat('%')) {
                expression = OpModKt.OpMod(x, this.parseFactorOp(OpGlobalContext.INSTANCE));
            } else {
                return x;
            }
            x = expression;
        }
    }

    private final Expression parseFactorOp(Expression context) {
        Expression expression;
        block45: {
            block51: {
                Number number;
                block53: {
                    Object object;
                    NumberFormat numberFormat;
                    block55: {
                        String n;
                        block54: {
                            String it;
                            block52: {
                                char it2;
                                block50: {
                                    Expression start3;
                                    block49: {
                                        block48: {
                                            block47: {
                                                block46: {
                                                    block44: {
                                                        if (!(context instanceof OpGlobalContext) || !this.eatSequence("++")) break block44;
                                                        int start2 = this.pos;
                                                        Expression variable = this.parseFactorOp(OpGlobalContext.INSTANCE);
                                                        if (!OpIncrementKt.isAssignable(variable)) {
                                                            boolean $i$a$-require-ExpressionInterpreterImpl$parseFactorOp$parsedOp$32 = false;
                                                            String $i$a$-require-ExpressionInterpreterImpl$parseFactorOp$parsedOp$32 = "Unexpected '++' as " + start2;
                                                            throw new IllegalArgumentException($i$a$-require-ExpressionInterpreterImpl$parseFactorOp$parsedOp$32.toString());
                                                        }
                                                        expression = OpIncrementKt.OpIncrement(variable);
                                                        break block45;
                                                    }
                                                    if (!(context instanceof OpGlobalContext) || !this.eatSequence("--")) break block46;
                                                    int start3 = this.pos;
                                                    Expression variable = this.parseFactorOp(OpGlobalContext.INSTANCE);
                                                    if (!OpIncrementKt.isAssignable(variable)) {
                                                        boolean $i$a$-require-ExpressionInterpreterImpl$parseFactorOp$parsedOp$42 = false;
                                                        String $i$a$-require-ExpressionInterpreterImpl$parseFactorOp$parsedOp$42 = "Unexpected '--' as " + start3;
                                                        throw new IllegalArgumentException($i$a$-require-ExpressionInterpreterImpl$parseFactorOp$parsedOp$42.toString());
                                                    }
                                                    expression = OpIncrementKt.OpDecrement(variable);
                                                    break block45;
                                                }
                                                if (!(context instanceof OpGlobalContext) || !this.eat('+')) break block47;
                                                expression = OpUnaryKt.OpUnaryPlus(this.parseFactorOp(context));
                                                break block45;
                                            }
                                            if (!(context instanceof OpGlobalContext) || !this.eat('-')) break block48;
                                            expression = OpUnaryKt.OpUnaryMinus(this.parseFactorOp(context));
                                            break block45;
                                        }
                                        if (!(context instanceof OpGlobalContext) || this.nextSequenceIs("!=") || !this.eat('!')) break block49;
                                        expression = OpBooleansKt.OpNot(ExpressionInterpreterImpl.parseExpressionOp$default(this, context, null, 2, null));
                                        break block45;
                                    }
                                    if (!(context instanceof OpGlobalContext) || !this.eat('(')) break block50;
                                    Expression it3 = start3 = ExpressionInterpreterImpl.parseExpressionOp$default(this, context, null, 2, null);
                                    boolean bl = false;
                                    if (!this.eat(')')) {
                                        boolean $i$a$-require-ExpressionInterpreterImpl$parseFactorOp$parsedOp$3$22 = false;
                                        String $i$a$-require-ExpressionInterpreterImpl$parseFactorOp$parsedOp$3$22 = "Bad expression: Missing ')'";
                                        throw new IllegalArgumentException($i$a$-require-ExpressionInterpreterImpl$parseFactorOp$parsedOp$3$22.toString());
                                    }
                                    expression = start3;
                                    break block45;
                                }
                                if (!(context instanceof OpGlobalContext) || !this.nextCharIs((Function1<? super Character, Boolean>)((Function1)ExpressionInterpreterImpl::parseFactorOp$lambda$11))) break block51;
                                if (ExpressionKt.getEXPR_DEBUG_PRINT_ENABLED()) {
                                    System.out.print((Object)"making const number... ");
                                }
                                numberFormat = null;
                                numberFormat = NumberFormat.Dec;
                                boolean isFloat = false;
                                isFloat = this.nextCharIs((Function1<? super Character, Boolean>)((Function1)ExpressionInterpreterImpl::parseFactorOp$lambda$12));
                                int startPos = this.pos;
                                do {
                                    this.nextChar();
                                    char $i$a$-require-ExpressionInterpreterImpl$parseFactorOp$parsedOp$3$22 = Character.toLowerCase(this.ch);
                                    if ($i$a$-require-ExpressionInterpreterImpl$parseFactorOp$parsedOp$3$22 == '.') {
                                        if (isFloat) break;
                                        isFloat = true;
                                    } else {
                                        Character c = NumberFormat.Hex.getPrefix();
                                        if (c != null && $i$a$-require-ExpressionInterpreterImpl$parseFactorOp$parsedOp$3$22 == c.charValue()) {
                                            if (!(numberFormat == NumberFormat.Dec && !isFloat)) {
                                                boolean $i$a$-check-ExpressionInterpreterImpl$parseFactorOp$parsedOp$82 = false;
                                                String $i$a$-check-ExpressionInterpreterImpl$parseFactorOp$parsedOp$82 = "Invalid number at pos " + startPos;
                                                throw new IllegalStateException($i$a$-check-ExpressionInterpreterImpl$parseFactorOp$parsedOp$82.toString());
                                            }
                                            numberFormat = NumberFormat.Hex;
                                        } else {
                                            Character c2 = NumberFormat.Oct.getPrefix();
                                            if (c2 != null && $i$a$-require-ExpressionInterpreterImpl$parseFactorOp$parsedOp$3$22 == c2.charValue()) {
                                                if (!(numberFormat == NumberFormat.Dec && !isFloat)) {
                                                    boolean $i$a$-check-ExpressionInterpreterImpl$parseFactorOp$parsedOp$92 = false;
                                                    String $i$a$-check-ExpressionInterpreterImpl$parseFactorOp$parsedOp$92 = "Invalid number at pos " + startPos;
                                                    throw new IllegalStateException($i$a$-check-ExpressionInterpreterImpl$parseFactorOp$parsedOp$92.toString());
                                                }
                                                numberFormat = NumberFormat.Oct;
                                            } else {
                                                Character c3 = NumberFormat.Bin.getPrefix();
                                                if (c3 != null && $i$a$-require-ExpressionInterpreterImpl$parseFactorOp$parsedOp$3$22 == c3.charValue() && numberFormat != NumberFormat.Hex) {
                                                    if (!(numberFormat == NumberFormat.Dec && !isFloat)) {
                                                        boolean $i$a$-check-ExpressionInterpreterImpl$parseFactorOp$parsedOp$102 = false;
                                                        String $i$a$-check-ExpressionInterpreterImpl$parseFactorOp$parsedOp$102 = "Invalid number at pos " + startPos;
                                                        throw new IllegalStateException($i$a$-check-ExpressionInterpreterImpl$parseFactorOp$parsedOp$102.toString());
                                                    }
                                                    numberFormat = NumberFormat.Bin;
                                                }
                                            }
                                        }
                                    }
                                    it2 = Character.toLowerCase(this.ch);
                                    boolean bl = false;
                                } while (StringsKt.contains$default((CharSequence)numberFormat.getAlphabet(), (char)it2, (boolean)false, (int)2, null) || ExpressionInterpreterImplKt.access$getNumberFormatIndicators$p().contains(Character.valueOf(it2)));
                                String string = this.expr.substring(startPos, this.pos);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                                it = string;
                                boolean bl = false;
                                if (StringsKt.endsWith$default((CharSequence)it, (char)'.', (boolean)false, (int)2, null)) {
                                    this.prevChar();
                                    isFloat = false;
                                }
                                if (!isFloat) break block52;
                                number = Double.parseDouble(it);
                                break block53;
                            }
                            char[] cArray = new char[]{'.'};
                            n = StringsKt.trimEnd((String)it, (char[])cArray);
                            boolean bl = false;
                            object = numberFormat.getPrefix();
                            if (object == null) break block54;
                            char p0 = ((Character)object).charValue();
                            boolean bl2 = false;
                            String string = StringsKt.substringAfter$default((String)n, (char)p0, null, (int)2, null);
                            object = string;
                            if (string != null) break block55;
                        }
                        object = n;
                    }
                    number = UStringsKt.toULong((String)object, (int)numberFormat.getRadix());
                }
                Double num = number;
                if (ExpressionKt.getEXPR_DEBUG_PRINT_ENABLED()) {
                    System.out.println(num);
                }
                expression = OpConstantKt.OpConstant(num);
                break block45;
            }
            if (context instanceof OpGlobalContext && this.nextCharIs((Function1<? super Character, Boolean>)((Function1)new Function1<Object, Boolean>((Object)Character.valueOf('\'')){

                public final Boolean invoke(Object p0) {
                    return this.receiver.equals(p0);
                }
            })) || this.nextCharIs((Function1<? super Character, Boolean>)((Function1)new Function1<Object, Boolean>((Object)Character.valueOf('\"')){

                public final Boolean invoke(Object p0) {
                    return this.receiver.equals(p0);
                }
            }))) {
                if (ExpressionKt.getEXPR_DEBUG_PRINT_ENABLED()) {
                    System.out.print((Object)"making const string... ");
                }
                char c = this.ch;
                int startPos = this.pos;
                do {
                    this.nextChar();
                } while (!this.eat(c));
                String string = this.expr.substring(startPos, this.pos);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String str = StringsKt.dropLast((String)StringsKt.drop((String)string, (int)1), (int)1);
                if (ExpressionKt.getEXPR_DEBUG_PRINT_ENABLED()) {
                    System.out.println((Object)str);
                }
                expression = OpConstantKt.OpConstant(str);
            } else if (context instanceof OpGlobalContext && this.eat('[')) {
                List startPos;
                if (ExpressionKt.getEXPR_DEBUG_PRINT_ENABLED()) {
                    System.out.println((Object)"making array... ");
                }
                List $this$parseFactorOp_u24lambda_u2420 = startPos = CollectionsKt.createListBuilder();
                boolean bl = false;
                while (!this.eat(']')) {
                    $this$parseFactorOp_u24lambda_u2420.add(ExpressionInterpreterImpl.parseExpressionOp$default(this, context, null, 2, null));
                    if (this.eat(',')) continue;
                    if (this.eat(']')) break;
                    boolean bl3 = false;
                    String string = "Bad expression: missing ]";
                    throw new IllegalArgumentException(string.toString());
                }
                List arrayArgs = CollectionsKt.build((List)startPos);
                expression = OpMakeArrayKt.OpMakeArray(arrayArgs);
            } else if (!(context instanceof OpIfCondition) && !(context instanceof OpGlobalContext) && this.eat('[')) {
                OpIndex arrayArgs;
                if (ExpressionKt.getEXPR_DEBUG_PRINT_ENABLED()) {
                    System.out.println((Object)"making index... ");
                }
                OpIndex it = arrayArgs = new OpIndex(context, ExpressionInterpreterImpl.parseExpressionOp$default(this, OpGlobalContext.INSTANCE, null, 2, null));
                boolean bl = false;
                if (!this.eat(']')) {
                    boolean bl4 = false;
                    String string = "Bad expression: Missing ']'";
                    throw new IllegalArgumentException(string.toString());
                }
                expression = arrayArgs;
            } else if (context instanceof OpIfCondition) {
                if (ExpressionKt.getEXPR_DEBUG_PRINT_ENABLED()) {
                    System.out.print((Object)"parsing if...");
                }
                ((OpIfCondition)context).setOnTrue(ExpressionInterpreterImpl.parseBlock$default(this, false, false, 3, null));
                if (ExpressionKt.getEXPR_DEBUG_PRINT_ENABLED()) {
                    System.out.println((Object)"parsed onTrue...");
                }
                if (this.eatSequence("else")) {
                    ((OpIfCondition)context).setOnFalse(ExpressionInterpreterImpl.parseBlock$default(this, false, false, 3, null));
                    if (ExpressionKt.getEXPR_DEBUG_PRINT_ENABLED()) {
                        System.out.println((Object)"parsed onFalse...");
                    }
                }
                expression = context;
            } else if (ExpressionInterpreterImplKt.access$isFun(this.ch)) {
                String string;
                int startPos = this.pos;
                do {
                    this.nextChar();
                    if (this.pos >= this.expr.length() || !ExpressionInterpreterImplKt.access$isFun(this.ch)) break;
                    string = this.expr.substring(startPos, this.pos);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                } while (!ExpressionInterpreterImplKt.access$isReserved(string) || this.ch != ' ');
                String string2 = this.expr.substring(startPos, this.pos);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String func = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                expression = this.parseFunction(context, func);
            } else {
                throw new IllegalStateException(("Unsupported Lottie expression: " + this.expr).toString());
            }
        }
        Expression parsedOp2 = expression;
        return this.finish(parsedOp2);
    }

    private final Expression finish(Expression $this$finish) {
        return $this$finish instanceof ExpressionContext && this.nextCharIs((Function1<? super Character, Boolean>)((Function1)ExpressionInterpreterImpl::finish$lambda$23)) ? this.parseFunction($this$finish, null) : ($this$finish instanceof OpVar || $this$finish instanceof OpIfCondition && ((OpIfCondition)$this$finish).getOnTrue() == null || this.eat('.') || this.nextCharIs((Function1<? super Character, Boolean>)((Function1)new Function1<Object, Boolean>((Object)Character.valueOf('[')){

            public final Boolean invoke(Object p0) {
                return this.receiver.equals(p0);
            }
        })) ? this.parseFactorOp($this$finish) : $this$finish);
    }

    private final List<Expression> parseFunctionArgs(String name) {
        List list;
        if (!this.nextCharIs((Function1<? super Character, Boolean>)((Function1)new Function1<Object, Boolean>((Object)Character.valueOf('(')){

            public final Boolean invoke(Object p0) {
                return this.receiver.equals(p0);
            }
        }))) {
            return null;
        }
        List $this$parseFunctionArgs_u24lambda_u2425 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (this.eat('(') && !this.eat(')')) {
            do {
                $this$parseFunctionArgs_u24lambda_u2425.add(this.parseAssignment(OpGlobalContext.INSTANCE));
            } while (this.eat(','));
            if (!this.eat(')')) {
                boolean bl2 = false;
                String string = "Bad expression:Missing ')' after argument to " + name;
                throw new IllegalArgumentException(string.toString());
            }
        }
        return CollectionsKt.build((List)list);
    }

    /*
     * Unable to fully structure code
     */
    private final Expression parseFunction(Expression context, String func) {
        var3_3 = func;
        if (var3_3 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var3_3.hashCode()) {
            case 1380938712: {
                if (var3_3.equals("function")) {
                    tmp = 1;
                }
                break;
            }
            case 115131: {
                if (var3_3.equals("try")) {
                    tmp = 2;
                }
                break;
            }
            case 3211: {
                if (var3_3.equals("do")) {
                    tmp = 3;
                }
                break;
            }
            case 113101617: {
                if (var3_3.equals("while")) {
                    tmp = 4;
                }
                break;
            }
            case -934396624: {
                if (var3_3.equals("return")) {
                    tmp = 5;
                }
                break;
            }
        }
        switch (tmp) {
            case 1: {
                v0 = this.parseFunctionDefinition();
                break;
            }
            case 4: {
                if (ExpressionKt.getEXPR_DEBUG_PRINT_ENABLED()) {
                    System.out.println((Object)"making while loop");
                }
                v0 = OpLoopsKt.OpWhileLoop(this.parseWhileCondition(), ExpressionInterpreterImpl.parseBlock$default(this, false, false, 3, null));
                break;
            }
            case 3: {
                if (ExpressionKt.getEXPR_DEBUG_PRINT_ENABLED()) {
                    System.out.println((Object)"making do/while loop");
                }
                if (!((body = ExpressionInterpreterImpl.parseBlock$default(this, false, false, 3, null)) instanceof OpBlock)) {
                    $i$a$-check-ExpressionInterpreterImpl$parseFunction$1 = false;
                    $i$a$-check-ExpressionInterpreterImpl$parseFunction$1 = "Invalid do/while syntax";
                    throw new IllegalStateException($i$a$-check-ExpressionInterpreterImpl$parseFunction$1.toString());
                }
                if (!this.eatSequence("while")) {
                    $i$a$-check-ExpressionInterpreterImpl$parseFunction$2 = false;
                    $i$a$-check-ExpressionInterpreterImpl$parseFunction$2 = "Missing while condition in do/while block";
                    throw new IllegalStateException($i$a$-check-ExpressionInterpreterImpl$parseFunction$2.toString());
                }
                condition = this.parseWhileCondition();
                v0 = OpLoopsKt.OpDoWhileLoop(condition, (OpBlock)body);
                break;
            }
            case 5: {
                expr = ExpressionInterpreterImpl.parseExpressionOp$default(this, OpGlobalContext.INSTANCE, null, 2, null);
                if (ExpressionKt.getEXPR_DEBUG_PRINT_ENABLED()) {
                    System.out.println((Object)("making return with " + expr));
                }
                v0 = new OpReturn(expr);
                break;
            }
            case 2: {
                tryBlock = ExpressionInterpreterImpl.parseBlock$default(this, false, true, 1, null);
                if (this.eatSequence("catch")) {
                    if (this.eat('(')) {
                        start = this.pos;
                        while (!this.eat(')')) {
                            if (this.pos < this.expr.length()) continue;
                            break;
                        }
                        v1 = this.expr.substring(start, this.pos);
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"substring(...)");
                        v2 = TuplesKt.to((Object)StringsKt.trim((CharSequence)v1).toString(), (Object)this.parseBlock(false, true));
                    } else {
                        v2 = TuplesKt.to(null, (Object)ExpressionInterpreterImpl.parseBlock$default(this, false, true, 1, null));
                    }
                } else {
                    v2 = null;
                }
                catchBlock = v2;
                finallyBlock = this.eatSequence("finally") != false ? ExpressionInterpreterImpl.parseBlock$default(this, false, true, 1, null) : null;
                v3 = catchBlock;
                v4 = catchBlock;
                v0 = OpTryCatchKt.OpTryCatch(tryBlock, v3 != null ? (String)v3.getFirst() : null, v4 != null ? (Expression)v4.getSecond() : null, finallyBlock);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                args = this.parseFunctionArgs(func);
                if (ExpressionKt.getEXPR_DEBUG_PRINT_ENABLED()) {
                    System.out.println((Object)("making fun " + func));
                }
                if (context instanceof ExpressionContext) {
                    v5 = ((ExpressionContext)context).interpret(func, args);
                    if (v5 == null) {
                        if (args != null && func != null && this.context.getVariable(func) instanceof OpFunction) {
                            if (ExpressionKt.getEXPR_DEBUG_PRINT_ENABLED()) {
                                System.out.println((Object)("parsed call for defined function " + func));
                            }
                            v6 = OpFunctionKt.OpFunctionExec(func, args);
                        } else {
                            v6 = v5 = null;
                        }
                        if (v6 == null) {
                            v7 = func;
                            if (v7 == null) {
                                v7 = "null";
                            }
                            OpUtilKt.unresolvedReference(v7, (var7_16 = Reflection.getOrCreateKotlinClass(context.getClass()).getSimpleName()) != null && (var8_17 = StringsKt.substringAfter$default((String)var7_16, (String)"Op", null, (int)2, null)) != null ? StringsKt.substringBefore$default((String)var8_17, (String)"Context", null, (int)2, null) : null);
                            throw new KotlinNothingValueException();
                        }
                    }
                } else {
                    v5 = JsContext.Companion.interpret(context, func, args);
                    if (v5 == null) {
                        throw new IllegalStateException(("Unsupported Lottie expression function: " + func).toString());
                    }
                }
                return v5;
            }
        }
        return v0;
    }

    private final Expression parseWhileCondition() {
        if (!this.eat('(')) {
            boolean bl = false;
            String string = "Missing while loop condition";
            throw new IllegalStateException(string.toString());
        }
        Expression condition = ExpressionInterpreterImpl.parseExpressionOp$default(this, OpGlobalContext.INSTANCE, null, 2, null);
        if (!this.eat(')')) {
            boolean bl = false;
            String string = "Missing closing ')' in loop condition";
            throw new IllegalStateException(string.toString());
        }
        return condition;
    }

    /*
     * WARNING - void declaration
     */
    private final Expression parseFunctionDefinition() {
        List args;
        List list;
        int start = this.pos;
        while (this.ch != '(') {
            this.nextChar();
        }
        String string = this.expr.substring(start, this.pos);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String name = ((Object)StringsKt.trim((CharSequence)string)).toString();
        if (ExpressionKt.getEXPR_DEBUG_PRINT_ENABLED()) {
            System.out.println((Object)("making defined function " + name));
        }
        List<Expression> args2 = this.parseFunctionArgs(name);
        boolean bl = false;
        List<Expression> list2 = args2;
        if (list2 != null) {
            List<Expression> $this$fastMap$iv = list2;
            boolean $i$f$fastMap = false;
            ArrayList target$iv = new ArrayList($this$fastMap$iv.size());
            List<Expression> $this$fastForEach$iv$iv = $this$fastMap$iv;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                FunctionParam functionParam;
                void it;
                Expression item$iv$iv;
                Expression it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl2 = false;
                Expression expression = it$iv;
                Collection collection = target$iv;
                boolean bl3 = false;
                void var20_20 = it;
                if (var20_20 instanceof OpGetVariable) {
                    functionParam = new FunctionParam(((OpGetVariable)it).getName(), null);
                } else if (var20_20 instanceof OpAssign) {
                    functionParam = new FunctionParam(((OpAssign)it).getVariableName(), ((OpAssign)it).getAssignableValue());
                } else {
                    throw new IllegalStateException(("Invalid function declaration at " + start).toString());
                }
                collection.add(functionParam);
            }
            list = target$iv;
        } else {
            list = null;
        }
        if ((args = list) == null) {
            boolean $i$a$-checkNotNull-ExpressionInterpreterImpl$parseFunctionDefinition$22 = false;
            String $i$a$-checkNotNull-ExpressionInterpreterImpl$parseFunctionDefinition$22 = "Missing function args";
            throw new IllegalStateException($i$a$-checkNotNull-ExpressionInterpreterImpl$parseFunctionDefinition$22.toString());
        }
        if (!this.nextCharIs((Function1<? super Character, Boolean>)((Function1)new Function1<Object, Boolean>((Object)Character.valueOf('{')){

            public final Boolean invoke(Object p0) {
                return this.receiver.equals(p0);
            }
        }))) {
            boolean bl4 = false;
            String string2 = "Missing function body at " + this.pos;
            throw new IllegalStateException(string2.toString());
        }
        Expression block = ExpressionInterpreterImpl.parseBlock$default(this, false, false, 2, null);
        this.context.setVariable(name, new OpFunction(name, args, block), VariableType.Const);
        if (ExpressionKt.getEXPR_DEBUG_PRINT_ENABLED()) {
            System.out.println((Object)("registered function " + name));
        }
        return OpConstantKt.OpConstant(Undefined.INSTANCE);
    }

    private final Expression parseBlock(boolean scoped, boolean requireBlock) {
        List list;
        List $this$parseBlock_u24lambda_u2434 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (this.eat('{')) {
            while (!this.eat('}') && this.pos < this.expr.length()) {
                $this$parseBlock_u24lambda_u2434.add(this.parseAssignment(OpGlobalContext.INSTANCE));
                this.eat(';');
            }
        } else {
            if (requireBlock) {
                throw new IllegalStateException(("Unexpected token at " + this.pos + ": block start was expected").toString());
            }
            $this$parseBlock_u24lambda_u2434.add(this.parseAssignment(OpGlobalContext.INSTANCE));
        }
        List list2 = CollectionsKt.build((List)list);
        return new OpBlock(list2, scoped);
    }

    static /* synthetic */ Expression parseBlock$default(ExpressionInterpreterImpl expressionInterpreterImpl, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return expressionInterpreterImpl.parseBlock(bl, bl2);
    }

    private static final Object parseExpressionOp$lambda$5(Comparable a, Comparable b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return (Boolean)OpCompareKt.getOpLessComparator().invoke((Object)a, (Object)b) != false || (Boolean)OpCompareKt.getOpEqualsComparator().invoke((Object)a, (Object)b) != false;
    }

    private static final Object parseExpressionOp$lambda$6(Comparable a, Comparable b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return (Boolean)OpCompareKt.getOpGreaterComparator().invoke((Object)a, (Object)b) != false || (Boolean)OpCompareKt.getOpEqualsComparator().invoke((Object)a, (Object)b) != false;
    }

    private static final boolean parseFactorOp$lambda$11(char it) {
        return Character.isDigit(it) || it == '.';
    }

    private static final boolean parseFactorOp$lambda$12(char it) {
        return it == '.';
    }

    private static final boolean finish$lambda$23(char it) {
        return it == '(';
    }
}

