# DO NOT EDIT!
# This code was auto generated by the `protoc-gen-pokete-resources-python` plugin,
# part of the pokete project, by <lxgr@protonmail.com>
from typing import TypedDict


class BaseIcoDict(TypedDict):
    txt: str
    esc: list[str]


class BaseIco:
    def __init__(
        self,
        txt: str,
        esc: list[str]
    ):
        self.txt: str = txt
        self.esc: list[str] = esc

    @classmethod
    def from_dict(cls, _d: BaseIcoDict | None) -> "BaseIco | None":
        if _d is None:
            return None
        return cls(
            txt=_d["txt"],
            esc=_d["esc"],
        )

    @staticmethod
    def validate(_d: BaseIcoDict) -> bool:
        return all([
            "txt" in _d and type(_d["txt"]) is str,
            "esc" in _d and all(type(i) is str for i in _d["esc"]),
        ])

    def to_dict(self) -> BaseIcoDict:
        ret: BaseIcoDict = {}
        
        ret["txt"] = self.txt
        ret["esc"] = self.esc

        return ret


class PokeDict(TypedDict):
    name: str
    hp: int
    atc: int
    defense: int
    attacks: list[str]
    pool: list[str]
    miss_chance: float
    desc: str
    lose_xp: int
    rarity: float
    types: list[str]
    evolve_poke: str
    evolve_lvl: int
    initiative: int
    night_active: bool | None
    ico: list["BaseIcoDict"]


class Poke:
    def __init__(
        self,
        name: str,
        hp: int,
        atc: int,
        defense: int,
        attacks: list[str],
        pool: list[str],
        miss_chance: float,
        desc: str,
        lose_xp: int,
        rarity: float,
        types: list[str],
        evolve_poke: str,
        evolve_lvl: int,
        initiative: int,
        night_active: bool | None,
        ico: list["BaseIco"]
    ):
        self.name: str = name
        self.hp: int = hp
        self.atc: int = atc
        self.defense: int = defense
        self.attacks: list[str] = attacks
        self.pool: list[str] = pool
        self.miss_chance: float = miss_chance
        self.desc: str = desc
        self.lose_xp: int = lose_xp
        self.rarity: float = rarity
        self.types: list[str] = types
        self.evolve_poke: str = evolve_poke
        self.evolve_lvl: int = evolve_lvl
        self.initiative: int = initiative
        self.night_active: bool | None = night_active
        self.ico: list["BaseIco"] = ico

    @classmethod
    def from_dict(cls, _d: PokeDict | None) -> "Poke | None":
        if _d is None:
            return None
        return cls(
            name=_d["name"],
            hp=_d["hp"],
            atc=_d["atc"],
            defense=_d["defense"],
            attacks=_d["attacks"],
            pool=_d["pool"],
            miss_chance=_d["miss_chance"],
            desc=_d["desc"],
            lose_xp=_d["lose_xp"],
            rarity=_d["rarity"],
            types=_d["types"],
            evolve_poke=_d["evolve_poke"],
            evolve_lvl=_d["evolve_lvl"],
            initiative=_d["initiative"],
            night_active=_d.get("night_active", None),
            ico=[BaseIco.from_dict(i) for i in _d["ico"]],
        )

    @staticmethod
    def validate(_d: PokeDict) -> bool:
        return all([
            "name" in _d and type(_d["name"]) is str,
            "hp" in _d and type(_d["hp"]) is int,
            "atc" in _d and type(_d["atc"]) is int,
            "defense" in _d and type(_d["defense"]) is int,
            "attacks" in _d and all(type(i) is str for i in _d["attacks"]),
            "pool" in _d and all(type(i) is str for i in _d["pool"]),
            "miss_chance" in _d and type(_d["miss_chance"]) is float or type(_d["miss_chance"]) is int,
            "desc" in _d and type(_d["desc"]) is str,
            "lose_xp" in _d and type(_d["lose_xp"]) is int,
            "rarity" in _d and type(_d["rarity"]) is float or type(_d["rarity"]) is int,
            "types" in _d and all(type(i) is str for i in _d["types"]),
            "evolve_poke" in _d and type(_d["evolve_poke"]) is str,
            "evolve_lvl" in _d and type(_d["evolve_lvl"]) is int,
            "initiative" in _d and type(_d["initiative"]) is int,
            type(_d.get("night_active", None)) is bool or _d.get("night_active", None) is None,
            "ico" in _d and all(BaseIco.validate(i) for i in _d["ico"]),
        ])

    def to_dict(self) -> PokeDict:
        ret: PokeDict = {}
        
        ret["name"] = self.name
        ret["hp"] = self.hp
        ret["atc"] = self.atc
        ret["defense"] = self.defense
        ret["attacks"] = self.attacks
        ret["pool"] = self.pool
        ret["miss_chance"] = self.miss_chance
        ret["desc"] = self.desc
        ret["lose_xp"] = self.lose_xp
        ret["rarity"] = self.rarity
        ret["types"] = self.types
        ret["evolve_poke"] = self.evolve_poke
        ret["evolve_lvl"] = self.evolve_lvl
        ret["initiative"] = self.initiative
        if self.night_active is not None:
            ret["night_active"] = self.night_active
        ret["ico"] = [BaseIco.to_dict(i) for i in self.ico]

        return ret
