/**
 * ./src/components/finished.tsx
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import React from 'react';
import { Box, Newline, Text, Spacer } from 'ink';
import Title from './title.js';
import Steps from './steps.js';
import yaml from 'js-yaml';
import fs from 'fs';
export default function Finished({ installationDevice = '', hostName = '', userName = '', message = 'Press a key to continue...' }) {
    let productName = 'unknown';
    let version = 'x.x.x';
    let configRoot = '/etc/penguins-eggs.d/krill/';
    if (fs.existsSync('/etc/calamares/settings.conf')) {
        configRoot = '/etc/calamares/';
    }
    const settings = yaml.load(fs.readFileSync(configRoot + 'settings.conf', 'utf-8'));
    const branding = settings.branding;
    const calamares = yaml.load(fs.readFileSync(configRoot + 'branding/' + branding + '/branding.desc', 'utf-8'));
    productName = calamares.string_product_name;
    version = calamares.string_product_version;
    /**
    * totale width=75
    * step width=15
    * finestra with=59
    */
    const [activeField, setActiveField] = React.useState(0);
    const [submission, setSubmission] = React.useState();
    return (React.createElement(React.Fragment, null,
        React.createElement(Title, null),
        React.createElement(Box, { width: 75, height: 11, borderStyle: "round", flexDirection: "column" },
            React.createElement(Box, { flexDirection: "column" },
                React.createElement(Box, { flexDirection: "row" },
                    React.createElement(Steps, { step: 9 }),
                    React.createElement(Box, { flexDirection: "column" },
                        React.createElement(Box, null,
                            React.createElement(Text, { backgroundColor: "white", color: 'black' }, "Installation is finished!")),
                        React.createElement(Newline, null),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "Your system was installed on "),
                            React.createElement(Text, { color: "green" }, installationDevice)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "Host name was set as "),
                            React.createElement(Text, { color: "green" }, hostName)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "The user name is "),
                            React.createElement(Text, { color: "green" }, userName)),
                        React.createElement(Newline, null),
                        React.createElement(Box, null,
                            React.createElement(Spacer, null),
                            React.createElement(Text, { backgroundColor: "white", color: "black" }, message))))))));
}
