#!/usr/bin/bash
#
#   arch.sh - Check the 'arch' array conforms to requirements.
#
#   Copyright (c) 2014-2025 Pacman Development Team <pacman-dev@lists.archlinux.org>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

[[ -n "$LIBMAKEPKG_LINT_PKGBUILD_ARCH_SH" ]] && return
LIBMAKEPKG_LINT_PKGBUILD_ARCH_SH=1

MAKEPKG_LIBRARY=${MAKEPKG_LIBRARY:-'/usr/share/makepkg'}

source "$MAKEPKG_LIBRARY/util/message.sh"
source "$MAKEPKG_LIBRARY/util/pkgbuild.sh"


lint_pkgbuild_functions+=('lint_arch')


validate_arch() {
	local n="$1"; shift
	local a=("$@")

	if (( ${#a[@]} == 0 )); then
		error "$(gettext "%s is not allowed to be empty.")" "arch"
		ret=1
	else
		if in_array "any" "${a[@]}"; then
			if (( ${#a[@]} != 1 )); then
				error "$(gettext "Can not use '%s' architecture with other architectures")" "any"
				ret=1
			fi
		else
			if (( ! IGNOREARCH )); then
				if ! in_array "$CARCH" "${a[@]}"; then
					error "$(gettext "%s is not available for the '%s' architecture.")" "$n" "$CARCH"
					ret=1
				fi
			fi
		fi

		for a in "${arch[@]}"; do
			if [[ $a = *[![:alnum:]_]* ]]; then
				error "$(gettext "%s contains invalid characters: '%s'")" \
						'arch' "${a//[[:alnum:]_]}"
				ret=1
			fi
		done
	fi

	if (( ${#arch[@]} != $(printf "%s\n" ${arch[@]} | sort -u | wc -l) )); then
		error "$(gettext "%s can not contain duplicate values")" 'arch'
		ret=1
	fi
}

lint_arch() {
	local name list ret=0

	validate_arch "$pkgbase" "${arch[@]}"

	if (( ret == 0 )); then
		for name in "${pkgname[@]}"; do
			get_pkgbuild_attribute "$name" 'arch' 1 list
			validate_arch "$name" "${list[@]}"
		done
	fi

	return $ret
}
