'use strict';
const { cppdb } = require('../util');

exports.prepare = function prepare(sql) {
	return this[cppdb].prepare(sql, this, false);
};

exports.key = function key(key) {
	if (!Buffer.isBuffer(key))  throw new TypeError('Expected first argument to be a Buffer');
	return this[cppdb].key(key, key.length);
};

exports.rekey = function rekey(key) {
	if (!Buffer.isBuffer(key))  throw new TypeError('Expected first argument to be a Buffer');
	return this[cppdb].rekey(key, key.length);
};

exports.exec = function exec(sql) {
	this[cppdb].exec(sql);
	return this;
};

exports.close = function close() {
	this[cppdb].close();
	return this;
};

exports.loadExtension = function loadExtension(...args) {
	this[cppdb].loadExtension(...args);
	return this;
};

exports.defaultSafeIntegers = function defaultSafeIntegers(...args) {
	this[cppdb].defaultSafeIntegers(...args);
	return this;
};

exports.unsafeMode = function unsafeMode(...args) {
	this[cppdb].unsafeMode(...args);
	return this;
};

exports.getters = {
	name: {
		get: function name() { return this[cppdb].name; },
		enumerable: true,
	},
	open: {
		get: function open() { return this[cppdb].open; },
		enumerable: true,
	},
	inTransaction: {
		get: function inTransaction() { return this[cppdb].inTransaction; },
		enumerable: true,
	},
	readonly: {
		get: function readonly() { return this[cppdb].readonly; },
		enumerable: true,
	},
	memory: {
		get: function memory() { return this[cppdb].memory; },
		enumerable: true,
	},
};
