#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2024 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxvpnfwconfigdel.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=4

. "${RestrictedDir}"/nxfunct.sh

isRunByNodeOrPlayer

if test -x "/sbin/iptables"; then
  COMMAND_IPTABLES="/sbin/iptables"
elif test -x "/usr/sbin/iptables"; then
  COMMAND_IPTABLES="/usr/sbin/iptables"
else
  ${COMMAND_ECHO} "NX> 500 Error: iptables command not found."
  exit 1
fi

#
# User parameters.
#

SERVER_IP="${3}"
BACKEND_IP="${4}"

#
# Call iptables.
#

${COMMAND_IPTABLES} -P OUTPUT ACCEPT

${COMMAND_IPTABLES} -D OUTPUT -o lo -j ACCEPT

${COMMAND_IPTABLES} -D OUTPUT -d ${SERVER_IP} -j ACCEPT

${COMMAND_IPTABLES} -D OUTPUT -d ${BACKEND_IP} -j ACCEPT

${COMMAND_ECHO} "Exit success."