#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

PARAMS_COUNT_MIN=4
PARAMS_COUNT_MAX=99

. "${RestrictedDir}"/nxfunct.sh

isRunByNodeOrPlayer

if test -x "/sbin/ip"; then
  COMMAND_IP="/sbin/ip"
else
  ${COMMAND_ECHO} "NX> 500 Error: ip command not found."
  exit 1
fi

#
# User parameters.
#

for par in "${@:3}"; do
  if test "x${par}" = "x"; then
    ${COMMAND_ECHO} "NX> 500 Error: one of parameters is empty."

    exit 1
  fi
done

PAR_NEXT_HOP_IP="${3}"

#
# Find an interface that will be used for the next hop.
#

if [ "${PAR_NEXT_HOP_IP}" == "0.0.0.0" ]; then
  PAR_NEXT_HOP_INTERFACE=""
else
  PAR_NEXT_HOP_INTERFACE="$( ${COMMAND_IP} route get ${PAR_NEXT_HOP_IP} | \
                        ${COMMAND_GREP} -Po '(?<= dev ).+?(?= (src|proto))' )"
fi

#
# Store all passed networks as array.
# For each one look for the next hop IP and its interface.
#

for i in "${@:4}"; do

  if [ "${PAR_NEXT_HOP_IP}" == "0.0.0.0" ]; then
    nextHop="$( ${COMMAND_IP} route get ${i} | \
                   ${COMMAND_GREP} -Po '(?<= via ).+?(?= (src|proto|dev))' )"
    nextHopInt="$( ${COMMAND_IP} route get ${i} | \
                      ${COMMAND_GREP} -Po '(?<= dev ).+?(?= (src|proto))' )"
  else
    nextHop="${PAR_NEXT_HOP_IP}"
    nextHopInt="${PAR_NEXT_HOP_INTERFACE}"
  fi

  if [ "${NETWORKS}" == "" ]; then
    NETWORKS=( "$i" )
    HOPS_IP=( "$nextHop" )
    HOPS_INT=( "$nextHopInt" )
  else
    NETWORKS=( "${NETWORKS[@]}" "$i" )
    HOPS_IP=( "${HOPS_IP[@]}" "$nextHop" )
    HOPS_INT=( "${HOPS_INT[@]}" "$nextHopInt" )
  fi
done

