#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxdbusmonitor.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=7

. "${RestrictedDir}"/nxfunct.sh

isRunByServer

if test -x "/bin/dbus-monitor"; then
  COMMAND_DBUSM="/bin/dbus-monitor"
elif test -x "/usr/bin/dbus-monitor"; then
  COMMAND_DBUSM="/usr/bin/dbus-monitor"
elif test -x "/usr/sbin/dbus-monitor"; then
  COMMAND_DBUSM="/usr/sbin/dbus-monitor"
else
  errorCommandNotFound "dbus-monitor" "1"
fi

TYPE="$3"
PROPERTY="$4"
SENDER="$5"
INTERFACE="$6"
MEMBER="$7"

if test "x$PROPERTY" != "x" ; then
  PARAM="type='$PROPERTY'"
fi

if test "x$SENDER" != "x" ; then
  if test "x$PARAM" != "x" ; then
    PARAM=$PARAM", sender='$SENDER'"
  else
    PARAM="sender='$SENDER'"
  fi
fi

if test "x$INTERFACE" != "x" ; then
  if test "x$PARAM" != "x" ; then
    PARAM=$PARAM", interface='$INTERFACE'"
  else
    PARAM="interface='$INTERFACE'"
  fi
fi

if test "x$MEMBER" != "x" ; then
  if test "x$PARAM" != "x" ; then
    PARAM=$PARAM", member='$MEMBER'"
  else
    PARAM="member='$MEMBER'"
  fi
fi

${COMMAND_DBUSM} --"${TYPE}" "${PARAM}"

exit $?
