#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxuserdel.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT_MIN=4
PARAMS_COUNT_MAX=5

. "${RestrictedDir}"/nxfunct.sh

isRunByServer

if test -x "/usr/sbin/userdel"; then
  COMMAND_USERDEL="/usr/sbin/userdel"
else
  errorCommandNotFound "userdel" "1"
fi

if test "x$5" = "xpkill"; then
  if test -x "/usr/bin/pkill"; then
    COMMAND_PKILL="/usr/bin/pkill"
  else
    errorCommandNotFound "pkill" "1"
  fi

  ${COMMAND_PKILL} -u $3
fi

if test "x$4" = "x1"; then
  ${COMMAND_USERDEL} -r $3
else
  ${COMMAND_USERDEL} $3
fi

ret=$?
if test ${ret} != 0; then
  exit ${ret}
fi

if test -f /etc/nscd.conf; then
  if test -x "/usr/sbin/nscd"; then
    COMMAND_NSCD="/usr/sbin/nscd"
  else
    errorCommandNotFound "nscd" "1"
  fi

  ${COMMAND_NSCD} -i passwd
fi

exit 0
