#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxupdate.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT_MIN=4
PARAMS_COUNT_MAX=8

. "${RestrictedDir}"/nxfunct.sh

isRunByServerOrNode

getNXRoot

if test -d "${NX_ROOT}/../MacOS"; then
  COMMAND_NXRUNNER="${NX_ROOT}/bin/nxrunner"
  export PATH="/bin:/usr/bin:/usr/X11/bin"

else
  COMMAND_NXRUNNER="${NX_ROOT}/bin/nxrunner.bin"
  export PATH="/bin:/usr/bin:/usr/X11R6/bin"
fi

if test ! -x "${COMMAND_NXRUNNER}"; then
  errorCommandNotFound "${COMMAND_NXRUNNER}" "1"
fi

HOME_DIR=$(/bin/bash -c "cd ~$1 2>/dev/null && pwd")

if test -z "${HOME_DIR}"; then
  errorMsg "Cannot retrieve user home directory." "1"
fi

export LD_LIBRARY_PATH="${NX_ROOT}/lib"
export NX_SYSTEM="${NX_ROOT}"
export HOME=${HOME_DIR}
export NX_CONFIG="${HOME}/.nx"
export NX_ROOT="${HOME}/.nx"

export NX_USER="$1"
export NX_GROUP="$3"

if ! test "$(${COMMAND_ID} -Gn ${NX_USER} | ${COMMAND_GREP} -w ${NX_GROUP})"; then
  errorMsg "Incorrect group membership." "1"
fi

if test "x$4" = "xsilent"; then

  export XAUTHORITY="$5"
  export DISPLAY="$6"

  if [ "x$7" = "x" ];
  then
    exec ${COMMAND_NXRUNNER} --update check --silent
  else
    exec ${COMMAND_NXRUNNER} --update check --silent --ignore "$7"
  fi

else

  if [ "x$5" = "xcheck" ] || [ "x$5" = "xdownload" ] || [ "x$5" = "xinstall" ];
  then
    MODE="$5"

    exec ${COMMAND_NXRUNNER} --update ${MODE} --background

  elif [ "x$5" = "xask" ];
  then
    MODE="$5"
    ROOT_PATH="$6"
    export XAUTHORITY="$7"
    export DISPLAY="$8"

    exec ${COMMAND_NXRUNNER} --update ${MODE} --background --root "${ROOT_PATH}"

  else
    errorMsg "Wrong parameter mode." "1"
  fi

fi
