#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxtruncate.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=3

. "${RestrictedDir}"/nxfunct.sh

isRunByServer

DIRECTORY="$3"
FILE_NAME="webrunner.log"

if test "x${DIRECTORY}" = "x"; then
  errorMsg "Missing file directory parameter." "1"
fi

if test ! -d "${DIRECTORY}"; then
  errorMsg "Directory ${DIRECTORY} does not exist." "1"
fi

FILE_PATH="${DIRECTORY}/${FILE_NAME}"

if test -f "${FILE_PATH}"; then
  > "${FILE_PATH}"
else
  errorMsg "File ${FILE_PATH} does not exist." "1"
fi

exit $?
