#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxtmpperm.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=2

. "${RestrictedDir}"/nxfunct.sh

isRunByNode

ice_dir=/tmp/.ICE-unix;
x11_dir=/tmp/.X11-unix;

for dirname in ${x11_dir} ${ice_dir} ; do
{
  if [ -e ${dirname} ]; then
    if [ ! -d ${dirname} ] || [ -L ${dirname} ]; then
      if test -e "${dirname}.backup"; then
        ${COMMAND_RM} ${dirname}

        if test $? != 0; then
          errorMsg "Cannot remove ${dirname}." "1"
        fi
      else
        ${COMMAND_MV} ${dirname} "${dirname}.backup"

        if test $? != 0; then
          ${COMMAND_RM} ${dirname}

          if test $? != 0; then
            errorMsg "Cannot remove ${dirname}." "1"
          fi
        fi
      fi

      ${COMMAND_MKDIR} ${dirname}
      if test $? != 0; then
        errorMsg "Cannot create directory ${dirname}." "1"
      fi
    elif [ -d ${dirname} ]; then
      if test ! -O ${dirname}; then
        getRootGName

        if test -L ${dirname}; then
          errorMsg "${dirname} is a symbolic link, skip change owner." "1"
        fi

        ${COMMAND_CHOWN} root:${ROOTGNAME} ${dirname}
        if test $? != 0; then
          errorMsg "Cannot chown ${dirname}." "1"
        fi
      fi
    fi
  else
    ${COMMAND_MKDIR} ${dirname}
    if test $? != 0; then
      errorMsg "Cannot create directory ${dirname}." "1"
    fi
  fi

  if test ! -O ${dirname}; then
    errorMsg "${dirname} is not owned by root, skip change permissions." "1"
  fi

  if test -L ${dirname}; then
    errorMsg "${dirname} is a symbolic link, skip change permissions." "1"
  fi

  ${COMMAND_CHMOD} 1777 ${dirname}
  if test $? != 0; then
    errorMsg "Cannot chmod ${dirname}." "1"
  fi
}
done

if test -x /sbin/restorecon; then
  /sbin/restorecon -v ${x11_dir}
fi

