#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2025 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxportandcookieget.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=2

. "${RestrictedDir}"/nxfunct.sh

isRunByNodeOrPlayer

installDir=$(cd "${RestrictedDir}/../../" && pwd)

DIRECTORY_PATH="$installDir/var/db/server"

if [ -e "/bin/cat" ];
then
  COMMAND_CAT="/bin/cat"
elif [ -e "/usr/bin/cat" ];
then
  COMMAND_CAT="/usr/bin/cat"
else
  errorMsg "cat command not found." "1"
  exit 1
fi

if test "x${DIRECTORY_PATH}" = "x"; then
  errorMsg "Missing command directory parameter." "1"
  exit 1
fi

if [ ! -e "${DIRECTORY_PATH}" ]; then
  errorMsg "${DIRECTORY_PATH} not found." "1"
  exit 1
fi

if [ ! -e "${DIRECTORY_PATH}/cookie" ]; then
  errorMsg "${DIRECTORY_PATH}/cookie not found." "1"
  exit 1
fi

if [ ! -e "${DIRECTORY_PATH}/port" ]; then
  errorMsg "${DIRECTORY_PATH}/port not found." "1"
  exit 1
fi

if [ ! -f "${DIRECTORY_PATH}/port" ] || [ -L "${DIRECTORY_PATH}/port" ]; then
  errorMsg "${DIRECTORY_PATH}/port is not a plain file." "1"
  exit 1
fi

if [ ! -f "${DIRECTORY_PATH}/cookie" ] || [ -L "${DIRECTORY_PATH}/cookie" ]; then
  errorMsg "${DIRECTORY_PATH}/cookie is not a plain file." "1"
  exit 1
fi

${COMMAND_CAT} "${DIRECTORY_PATH}/port"
echo ""
${COMMAND_CAT} "${DIRECTORY_PATH}/cookie"
