/*
 * Microsoft Application Insights Web Snippet, 1.2.3
 * Copyright (c) Microsoft and contributors. All rights reserved.
 *
 * 
 * 
 */

declare namespace ApplicationInsights {
    function getSdkLoaderScript(config: SdkLoaderConfig): string;

    interface SdkLoaderConfig {
        instrumentationKey?: string;
        connectionString?: string;
        src?: string;
        name?: string;
        ld?: number;
        useXhr?: boolean;
        crossOrigin?: string;
        cfg?: any;
        cr?: boolean;
        dle?: boolean;
        sri?: boolean;
        pl?: boolean;
        pn?: string;
        ttp?: TrustedTypePolicy;
    }

    abstract class TrustedTypePolicy {
        readonly name: string;
        createHTML?: ((input: string, ...args: any[]) => string) | undefined;
        createScript?: ((input: string, ...args: any[]) => string) | undefined;
        createScriptURL?: ((input: string, ...args: any[]) => string) | undefined;
    }

    const webSnippet = "##replaceIKeySnippet##";

    const webSnippetCs = "##replaceConnStringSnippet##";

    function webSnippetVersion(): string;

}