var strEmpty$1 = "";
function _getTime() {
    var date = new Date();
    function pad(num) {
        var r = strEmpty$1 + num;
        if (r.length === 1) {
            r = "0" + r;
        }
        return r;
    }
    return date.getUTCFullYear()
        + "-" + pad(date.getUTCMonth() + 1)
        + "-" + pad(date.getUTCDate())
        + "T" + pad(date.getUTCHours())
        + ":" + pad(date.getUTCMinutes())
        + ":" + pad(date.getUTCSeconds())
        + "." + String((date.getUTCMilliseconds() / 1000).toFixed(3)).slice(2, 5)
        + "Z";
}

var strEmpty = "";
function _createAiEnvelope(iKey, theType, sv, version, locn) {
    var tags = {};
    var type = "Browser";
    var strAiDevice = "ai.device.";
    var strAiOperationName = "ai.operation.name";
    var strAiSdkVersion = "ai.internal.sdkVersion";
    var strToLowerCase = "toLowerCase";
    tags[strAiDevice + "id"] = type[strToLowerCase]();
    tags[strAiDevice + "type"] = type;
    tags[strAiOperationName] = locn && locn.pathname || "_unknown_";
    tags[strAiSdkVersion] = "javascript:snippet_" + (sv || version);
    var envelope = {
        time: _getTime(),
        iKey: iKey,
        name: "Microsoft.ApplicationInsights." + iKey.replace(/-/g, strEmpty) + "." + theType,
        sampleRate: 100,
        tags: tags,
        data: {
            baseData: {
                ver: 2
            }
        },
        ver: undefined,
        seq: "1",
        aiDataContract: undefined
    };
    return envelope;
}
var track = "track";
var trackPage = "TrackPage";
var trackEvent = "TrackEvent";
var aiMethod = [
    track + "Event",
    track + "Exception",
    track + "PageView",
    track + "PageViewPerformance",
    "addTelemetryInitializer",
    track + "Trace",
    track + "DependencyData",
    track + "Metric",
    "start" + trackPage,
    "stop" + trackPage,
    "start" + trackEvent,
    "stop" + trackEvent,
    "setAuthenticatedUserContext",
    "clearAuthenticatedUserContext",
    "flush"
];

(function (win, doc, cfg) {
    var locn = win.location;
    var helpLink = "https://go.microsoft.com/fwlink/?linkid=2128109";
    var scriptText = "script";
    var strInstrumentationKey = "instrumentationKey";
    var strIngestionendpoint = "ingestionendpoint";
    var strDisableExceptionTracking = "disableExceptionTracking";
    var strToLowerCase = "toLowerCase";
    var strConStringIKey = strInstrumentationKey[strToLowerCase]();
    var strEmpty = "";
    var strUndefined = "undefined";
    var strCrossOrigin = "crossOrigin";
    var strJsonResponseError = "Error Loading JSON response";
    var strPostMethod = "POST";
    var strGetMethod = "GET";
    var policyName = cfg.pn || "aiPolicy";
    var sdkInstanceName;
    var aiName;
    {
        sdkInstanceName = "appInsightsSDK";
        aiName = cfg.name || "appInsights";
    }
    if (cfg.name || win[sdkInstanceName]) {
        win[sdkInstanceName] = aiName;
    }
    var aiSdk = win[aiName] || (function (aiConfig, aiExtensions) {
        var targetSrc = aiConfig["url"] || cfg.src;
        var loadFailed = false;
        var handled = false;
        var appInsights = {
            initialize: true,
            queue: [],
            sv: "10",
            config: aiConfig,
            version: 2.0,
            extensions: aiExtensions
        };
        function isIE() {
            var nav = navigator;
            if (nav) {
                var userAgent = (nav.userAgent || "").toLowerCase();
                return (userAgent.indexOf("msie") !== -1 || userAgent.indexOf("trident/") !== -1);
            }
            return false;
        }
        function _parseConnectionString() {
            var fields = {};
            var connectionString = aiConfig.connectionString;
            if (typeof connectionString === "string" && connectionString) {
                var kvPairs = connectionString.split(";");
                for (var lp = 0; lp < kvPairs.length; lp++) {
                    var kvParts = kvPairs[lp].split("=");
                    if (kvParts.length === 2) {
                        fields[kvParts[0][strToLowerCase]()] = kvParts[1];
                    }
                }
            }
            if (!fields[strIngestionendpoint]) {
                var endpointSuffix = fields.endpointsuffix;
                var fLocation = endpointSuffix ? fields.location : null;
                fields[strIngestionendpoint] = "https://" + (fLocation ? fLocation + "." : strEmpty) + "dc." + (endpointSuffix || "services.visualstudio.com");
            }
            return fields;
        }
        function _sendEvents(evts, endpointUrl) {
            if (JSON) {
                var sender = win.fetch;
                if (sender && !cfg.useXhr) {
                    sender(endpointUrl, { method: strPostMethod, body: JSON.stringify(evts), mode: "cors" });
                }
                else if (XMLHttpRequest) {
                    var xhr = new XMLHttpRequest();
                    xhr.open(strPostMethod, endpointUrl);
                    xhr.setRequestHeader("Content-type", "application/json");
                    xhr.send(JSON.stringify(evts));
                }
            }
        }
        function _reportFailure(targetSrc) {
            if (cfg.dle === true) {
                return;
            }
            var iKey;
            var endpointUrl;
            {
                var conString = _parseConnectionString();
                iKey = conString[strConStringIKey] || aiConfig[strInstrumentationKey] || strEmpty;
                var ingest = conString[strIngestionendpoint];
                if (ingest && ingest.slice(-1) === "/") {
                    ingest = ingest.slice(0, -1);
                }
                endpointUrl = ingest ? ingest + "/v2/track" : aiConfig.endpointUrl;
                endpointUrl = aiConfig.userOverrideEndpointUrl ? aiConfig.userOverrideEndpointUrl : endpointUrl;
            }
            var message = "SDK LOAD Failure: Failed to load Application Insights SDK script (See stack for details)";
            var evts = [];
            evts.push(_createException(iKey, message, targetSrc, endpointUrl));
            {
                evts.push(_createInternal(iKey, message, targetSrc, endpointUrl));
            }
            _sendEvents(evts, endpointUrl);
        }
        function _createEnvelope(iKey, theType) {
            {
                return _createAiEnvelope(iKey, theType, appInsights.sv, appInsights.version, locn);
            }
        }
        function _createInternal(iKey, message, targetSrc, endpointUrl) {
            var envelope = _createEnvelope(iKey, "Message");
            var data = envelope.data;
            data.baseType = "MessageData";
            var baseData = data.baseData;
            baseData.message = "AI (Internal): 99 message:\"" + (message + " (" + targetSrc + ")").replace(/\"/g, strEmpty) + "\"";
            baseData.properties = {
                endpoint: endpointUrl
            };
            return envelope;
        }
        function _createException(iKey, message, targetSrc, endpointUrl) {
            var envelope;
            {
                envelope = _createEnvelope(iKey, "Exception");
            }
            var data = envelope.data;
            data.baseType = "ExceptionData";
            data.baseData.exceptions = [{
                    typeName: "SDKLoadFailed",
                    message: message.replace(/\./g, "-"),
                    hasFullStack: false,
                    stack: message + "\nSnippet failed to load [" + targetSrc + "] -- Telemetry is disabled\nHelp Link: " + helpLink + "\nHost: " + (locn && locn.pathname || "_unknown_") + "\nEndpoint: " + endpointUrl,
                    parsedStack: []
                }];
            return envelope;
        }
        var domainRetryIndex = -1;
        var domainRetryCount = 0;
        var domains = [
            "js.monitor.azure.com",
            "js.cdn.applicationinsights.io",
            "js.cdn.monitor.azure.com",
            "js0.cdn.applicationinsights.io",
            "js0.cdn.monitor.azure.com",
            "js2.cdn.applicationinsights.io",
            "js2.cdn.monitor.azure.com",
            "az416426.vo.msecnd.net"
        ];
        var fallback = function () { return setScript(targetSrc, null); };
        if (cfg.sri) {
            var match_1 = targetSrc.match(/^((http[s]?:\/\/.*\/)\w+(\.\d+){1,5})\.(([\w]+\.){0,2}js)$/);
            if (match_1 && match_1.length === 6) {
                var integrityUrl = "".concat(match_1[1], ".integrity.json");
                var targetType_1 = "@".concat(match_1[4]);
                var sender = window.fetch;
                var handleResponse_1 = function (json) {
                    if (!json.ext || !json.ext[targetType_1] || !json.ext[targetType_1].file) {
                        throw new Error(strJsonResponseError);
                    }
                    var integrity = json.ext[targetType_1].integrity || null;
                    targetSrc = match_1[2] + json.ext[targetType_1].file;
                    setScript(targetSrc, integrity);
                };
                if (sender && !cfg.useXhr) {
                    sender(integrityUrl, { method: strGetMethod, mode: "cors" })
                        .then(function (response) { return response.json().catch(function () { return ({}); }); })
                        .then(handleResponse_1)
                        .catch(fallback);
                }
                else if (XMLHttpRequest) {
                    var xhr_1 = new XMLHttpRequest();
                    xhr_1.open(strGetMethod, integrityUrl);
                    xhr_1.onreadystatechange = function () {
                        if (xhr_1.readyState === XMLHttpRequest.DONE) {
                            if (xhr_1.status === 200) {
                                try {
                                    handleResponse_1(JSON.parse(xhr_1.responseText));
                                }
                                catch (_a) {
                                    fallback();
                                }
                            }
                            else {
                                fallback();
                            }
                        }
                    };
                    xhr_1.send();
                }
            }
            else if (targetSrc) {
                fallback();
            }
        }
        else if (targetSrc) {
            fallback();
        }
        function setScript(targetSrc, integrity) {
            if (isIE() && targetSrc.indexOf("ai.3") !== -1) {
                targetSrc = targetSrc.replace(/(\/)(ai\.3\.)([^\d]*)$/, function (_all, g1, g2) {
                    return g1 + "ai.2" + g2;
                });
            }
            if (cfg.cr !== false) {
                for (var i = 0; i < domains.length; i++) {
                    if (targetSrc.indexOf(domains[i]) > 0) {
                        domainRetryIndex = i;
                        break;
                    }
                }
            }
            var _handleError = function (evt) {
                appInsights.queue = [];
                if (!handled) {
                    if (domainRetryIndex >= 0 && domainRetryCount + 1 < domains.length) {
                        var nextIdx_1 = (domainRetryIndex + domainRetryCount + 1) % domains.length;
                        _createScript(targetSrc.replace(/^(.*\/\/)([\w\.]*)(\/.*)$/, function (_all, http, domain, qs) {
                            return http + domains[nextIdx_1] + qs;
                        }));
                        domainRetryCount += 1;
                    }
                    else {
                        handled = true;
                        loadFailed = true;
                        _reportFailure(targetSrc);
                    }
                }
            };
            var _handleLoad = function (evt, isAbort) {
                if (!handled) {
                    setTimeout(function () {
                        if (isAbort) {
                            {
                                if (!appInsights.core) {
                                    _handleError();
                                }
                            }
                        }
                    }, 500);
                }
                loadFailed = false;
            };
            function create_policy() {
                var _a;
                function validateURL(urlString) {
                    try {
                        var url = new URL(urlString);
                        if (url.host && url.host === "js.monitor.azure.com") {
                            return urlString;
                        }
                        else {
                            handleInvalidURL(urlString);
                        }
                    }
                    catch (_a) {
                        handleInvalidURL(urlString);
                    }
                }
                function handleInvalidURL(urlString) {
                    _reportFailure("AI policy blocked URL: " + urlString);
                }
                return (_a = window.trustedTypes) === null || _a === void 0 ? void 0 : _a.createPolicy(policyName, {
                    createScriptURL: validateURL
                });
            }
            var _createScript = function (src) {
                var scriptElement = doc.createElement(scriptText);
                if (cfg.pl) {
                    if (cfg.ttp && cfg.ttp.createScript) {
                        scriptElement["src"] = cfg.ttp.createScriptURL(src);
                    }
                    else {
                        scriptElement["src"] = create_policy().createScriptURL(src);
                    }
                }
                else {
                    scriptElement["src"] = src;
                }
                if (cfg.nt) {
                    scriptElement.setAttribute("nonce", cfg.nt);
                }
                if (integrity) {
                    scriptElement.integrity = integrity;
                }
                scriptElement.setAttribute("data-ai-name", aiName);
                var crossOrigin = cfg[strCrossOrigin];
                if ((crossOrigin || crossOrigin === "") && scriptElement[strCrossOrigin] != strUndefined) {
                    scriptElement[strCrossOrigin] = crossOrigin;
                }
                scriptElement.onload = _handleLoad;
                scriptElement.onerror = _handleError;
                scriptElement["onreadystatechange"] = function (evt, isAbort) {
                    if (scriptElement["readyState"] === "loaded" || scriptElement["readyState"] === "complete") {
                        _handleLoad(evt, isAbort);
                    }
                };
                if (cfg.ld && cfg.ld < 0) {
                    var headNode = doc.getElementsByTagName("head")[0];
                    headNode.appendChild(scriptElement);
                }
                else {
                    setTimeout(function () {
                        doc.getElementsByTagName(scriptText)[0].parentNode.appendChild(scriptElement);
                    }, cfg.ld || 0);
                }
                return scriptElement;
            };
            _createScript(targetSrc);
        }
        try {
            appInsights.cookie = doc.cookie;
        }
        catch (e) {
        }
        function _createMethods(methods) {
            while (methods.length) {
                (function (name) {
                    appInsights[name] = function () {
                        var originalArguments = arguments;
                        if (!loadFailed) {
                            appInsights.queue.push(function () {
                                appInsights[name].apply(appInsights, originalArguments);
                            });
                        }
                    };
                })(methods.pop());
            }
        }
        {
            _createMethods(aiMethod);
        }
        appInsights["SeverityLevel"] = {
            Verbose: 0,
            Information: 1,
            Warning: 2,
            Error: 3,
            Critical: 4
        };
        var globalErrorCollect = false;
        {
            var analyticsCfg = ((aiConfig.extensionConfig || {}).ApplicationInsightsAnalytics || {});
            if (!(aiConfig[strDisableExceptionTracking] === true || analyticsCfg[strDisableExceptionTracking] === true)) {
                globalErrorCollect = true;
            }
        }
        if (globalErrorCollect) {
            var method_1 = "onerror";
            _createMethods(["_" + method_1]);
            var originalOnError_1 = win[method_1];
            win[method_1] = function (message, url, lineNumber, columnNumber, error) {
                var handled = originalOnError_1 && originalOnError_1(message, url, lineNumber, columnNumber, error);
                if (handled !== true) {
                    appInsights["_" + method_1]({
                        message: message,
                        url: url,
                        lineNumber: lineNumber,
                        columnNumber: columnNumber,
                        error: error,
                        evt: win.event
                    });
                }
                return handled;
            };
            aiConfig["autoExceptionInstrumented"] = true;
        }
        return appInsights;
    })(cfg.cfg);
    win[aiName] = aiSdk;
    function _onInit() {
        if (cfg.onInit) {
            cfg.onInit(aiSdk);
        }
    }
    if (aiSdk.queue && aiSdk.queue.length === 0) {
        aiSdk.queue.push(_onInit);
        {
            aiSdk.trackPageView({});
        }
    }
    else {
        _onInit();
    }
})(window, document, {
    src: "https://js.monitor.azure.com/scripts/b/ai.3.gbl.min.js",
    // name: "appInsights", // Global SDK Instance name defaults to "appInsights" when not supplied
    // ld: 0, // Defines the load delay (in ms) before attempting to load the sdk. -1 = block page load and add to head. (default) = 0ms load after timeout,
    // useXhr: 1, // Use XHR instead of fetch to report failures (if available),
    // dle: true, // Prevent the SDK from reporting load failure log
    crossOrigin: "anonymous", // When supplied this will add the provided value as the cross origin attribute on the script tag
    // onInit: null, // Once the application insights instance has loaded and initialized this callback function will be called with 1 argument -- the sdk instance (DO NOT ADD anything to the sdk.queue -- As they won't get called)
    // sri: false, // Custom optional value to specify whether fetching the snippet from integrity file and do integrity check 
    // pl: false, // Custom optional value to specify whether to enable the trusted type policy check on snippet
    // pn: "aiPolicy", // Custom optional value to specify the name of the trusted type policy that would be implemented on the snippet, default is "aiPolicy"
    // ttp: null, // Custom optional value to specify the trusted type policy that would be applied on the snippet src
    // nt: null, // Custom optional value to specify the nounce tag value that would be applied on the script when we drop it on the page
    cfg: { // Application Insights Configuration
        connectionString: "YOUR_CONNECTION_STRING"
    }
});
//# sourceMappingURL=snippet.js.map
