// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var charMap = {
    "<": "\\u003C",
    ">": "\\u003E",
    "\\": "\\\\",
    "\b": "\\b",
    "\f": "\\f",
    "\n": "\\n",
    "\r": "\\r",
    "\t": "\\t",
    "\0": "\\0",
    "\u2028": "\\u2028",
    "\u2029": "\\u2029"
};
var sourceMap = /\/\/# sourceMappingURL=.*\.js\.map$/gm;
export function _escapeUnsupportedChars(value) {
    if (value) {
        value = value.replace(/[<>\\\b\f\n\r\t\0\u2028\u2029]/g, function (match) {
            return charMap[match];
        });
    }
    return value;
}
export function _ensureBoolean(value) {
    if (value !== undefined) {
        value = !!value;
    }
    return value;
}
export function _ensureNumber(value) {
    if (value !== undefined) {
        value = Number(value);
    }
    return value;
}
export function _getSourceMap(value) {
    var rlt = "";
    var cleanedStr = value;
    if (value) {
        var matches = value.match(sourceMap);
        // process when there is only one source map
        if (matches && matches.length === 1) {
            rlt = matches[0].trim();
            cleanedStr = value.replace(sourceMap, "");
        }
    }
    return [rlt, cleanedStr];
}
