"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDocumentContext = getDocumentContext;
const strings_1 = require("../utils/strings");
const vscode_uri_1 = require("vscode-uri");
function getDocumentContext(documentUri, workspaceFolders) {
    function getRootFolder() {
        for (const folder of workspaceFolders) {
            let folderURI = folder.uri;
            if (!(0, strings_1.endsWith)(folderURI, '/')) {
                folderURI = folderURI + '/';
            }
            if ((0, strings_1.startsWith)(documentUri, folderURI)) {
                return folderURI;
            }
        }
        return undefined;
    }
    return {
        resolveReference: (ref, base = documentUri) => {
            if (ref.match(/^\w[\w\d+.-]*:/)) {
                return ref;
            }
            if (ref[0] === '/') {
                const folderUri = getRootFolder();
                if (folderUri) {
                    return folderUri + ref.substr(1);
                }
            }
            const baseUri = vscode_uri_1.URI.parse(base);
            const baseUriDir = baseUri.path.endsWith('/') ? baseUri : vscode_uri_1.Utils.dirname(baseUri);
            return vscode_uri_1.Utils.resolvePath(baseUriDir, ref).toString(true);
        },
    };
}
