import { RequestType, Connection } from 'vscode-languageserver';
import { RuntimeEnvironment } from './htmlServer';
export declare namespace FsStatRequest {
    const type: RequestType<string, FileStat, any>;
}
export declare namespace FsReadDirRequest {
    const type: RequestType<string, [string, FileType][], any>;
}
export declare enum FileType {
    Unknown = 0,
    File = 1,
    Directory = 2,
    SymbolicLink = 64
}
export interface FileStat {
    type: FileType;
    ctime: number;
    mtime: number;
    size: number;
}
export interface FileSystemProvider {
    stat(uri: string): Promise<FileStat>;
    readDirectory(uri: string): Promise<[string, FileType][]>;
}
export declare function getFileSystemProvider(handledSchemas: string[], connection: Connection, runtime: RuntimeEnvironment): FileSystemProvider;
