"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSemanticTokenLegend = getSemanticTokenLegend;
exports.getSemanticTokens = getSemanticTokens;
function getSemanticTokenLegend() {
    if (tokenTypes.length !== 12) {
        console.warn('TokenType has added new entries.');
    }
    if (tokenModifiers.length !== 6) {
        console.warn('TokenModifier has added new entries.');
    }
    return { types: tokenTypes, modifiers: tokenModifiers };
}
function* getSemanticTokens(jsLanguageService, document, fileName) {
    const { spans } = jsLanguageService.getEncodedSemanticClassifications(fileName, { start: 0, length: document.getText().length }, '2020');
    for (let i = 0; i < spans.length;) {
        const offset = spans[i++];
        const length = spans[i++];
        const tsClassification = spans[i++];
        const tokenType = getTokenTypeFromClassification(tsClassification);
        if (tokenType === undefined) {
            continue;
        }
        const tokenModifiers = getTokenModifierFromClassification(tsClassification);
        const startPos = document.positionAt(offset);
        yield {
            start: startPos,
            length: length,
            typeIdx: tokenType,
            modifierSet: tokenModifiers
        };
    }
}
function getTokenTypeFromClassification(tsClassification) {
    if (tsClassification > 255) {
        return (tsClassification >> 8) - 1;
    }
    return undefined;
}
function getTokenModifierFromClassification(tsClassification) {
    return tsClassification & 255;
}
const tokenTypes = [];
tokenTypes[0] = 'class';
tokenTypes[1] = 'enum';
tokenTypes[2] = 'interface';
tokenTypes[3] = 'namespace';
tokenTypes[4] = 'typeParameter';
tokenTypes[5] = 'type';
tokenTypes[6] = 'parameter';
tokenTypes[7] = 'variable';
tokenTypes[8] = 'enumMember';
tokenTypes[9] = 'property';
tokenTypes[10] = 'function';
tokenTypes[11] = 'method';
const tokenModifiers = [];
tokenModifiers[2] = 'async';
tokenModifiers[0] = 'declaration';
tokenModifiers[3] = 'readonly';
tokenModifiers[1] = 'static';
tokenModifiers[5] = 'local';
tokenModifiers[4] = 'defaultLibrary';
