"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadLibrary = loadLibrary;
const path_1 = require("path");
const fs_1 = require("fs");
const contents = {};
const isPacked = (0, path_1.basename)(__dirname) === 'lib';
const serverFolder = isPacked ? __dirname : (0, path_1.dirname)((0, path_1.dirname)((0, path_1.dirname)((0, path_1.dirname)((0, path_1.dirname)(__dirname)))));
const TYPESCRIPT_LIB_SOURCE = isPacked ? serverFolder : (0, path_1.join)(serverFolder, 'lib');
const JQUERY_PATH = isPacked ? (0, path_1.join)(serverFolder, 'jquery.d.ts') : (0, path_1.join)(serverFolder, 'lib/jquery.d.ts');
function loadLibrary(name) {
    let content = contents[name];
    if (typeof content !== 'string') {
        let libPath;
        if (name === 'jquery') {
            libPath = JQUERY_PATH;
        }
        else {
            libPath = (0, path_1.join)(TYPESCRIPT_LIB_SOURCE, name);
        }
        try {
            content = (0, fs_1.readFileSync)(libPath).toString();
        }
        catch (e) {
            console.log(`Unable to load library ${name} at ${libPath}`);
            content = '';
        }
        contents[name] = content;
    }
    return content;
}
