"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getHTMLMode = getHTMLMode;
const languageModelCache_1 = require("../languageModelCache");
function getHTMLMode(htmlLanguageService, workspace) {
    const htmlDocuments = (0, languageModelCache_1.getLanguageModelCache)(10, 60, document => htmlLanguageService.parseHTMLDocument(document));
    return {
        getId() {
            return 'html';
        },
        getSelectionRange(document, position) {
            return __awaiter(this, void 0, void 0, function* () {
                return htmlLanguageService.getSelectionRanges(document, [position])[0];
            });
        },
        doComplete(document, position, documentContext, settings = workspace.settings) {
            var _a, _b;
            const htmlSettings = settings === null || settings === void 0 ? void 0 : settings.html;
            const options = merge(htmlSettings === null || htmlSettings === void 0 ? void 0 : htmlSettings.suggest, {});
            options.hideAutoCompleteProposals = (htmlSettings === null || htmlSettings === void 0 ? void 0 : htmlSettings.autoClosingTags) === true;
            options.attributeDefaultValue = (_b = (_a = htmlSettings === null || htmlSettings === void 0 ? void 0 : htmlSettings.completion) === null || _a === void 0 ? void 0 : _a.attributeDefaultValue) !== null && _b !== void 0 ? _b : 'doublequotes';
            const htmlDocument = htmlDocuments.get(document);
            const completionList = htmlLanguageService.doComplete2(document, position, htmlDocument, documentContext, options);
            return completionList;
        },
        doHover(document, position, settings) {
            return __awaiter(this, void 0, void 0, function* () {
                var _a;
                return htmlLanguageService.doHover(document, position, htmlDocuments.get(document), (_a = settings === null || settings === void 0 ? void 0 : settings.html) === null || _a === void 0 ? void 0 : _a.hover);
            });
        },
        findDocumentHighlight(document, position) {
            return __awaiter(this, void 0, void 0, function* () {
                return htmlLanguageService.findDocumentHighlights(document, position, htmlDocuments.get(document));
            });
        },
        findDocumentLinks(document, documentContext) {
            return __awaiter(this, void 0, void 0, function* () {
                return htmlLanguageService.findDocumentLinks(document, documentContext);
            });
        },
        findDocumentSymbols(document) {
            return __awaiter(this, void 0, void 0, function* () {
                return htmlLanguageService.findDocumentSymbols(document, htmlDocuments.get(document));
            });
        },
        format(document_1, range_1, formatParams_1) {
            return __awaiter(this, arguments, void 0, function* (document, range, formatParams, settings = workspace.settings) {
                var _a;
                const formatSettings = merge((_a = settings === null || settings === void 0 ? void 0 : settings.html) === null || _a === void 0 ? void 0 : _a.format, {});
                if (formatSettings.contentUnformatted) {
                    formatSettings.contentUnformatted = formatSettings.contentUnformatted + ',script';
                }
                else {
                    formatSettings.contentUnformatted = 'script';
                }
                merge(formatParams, formatSettings);
                return htmlLanguageService.format(document, range, formatSettings);
            });
        },
        getFoldingRanges(document) {
            return __awaiter(this, void 0, void 0, function* () {
                return htmlLanguageService.getFoldingRanges(document);
            });
        },
        doAutoInsert(document_1, position_1, kind_1) {
            return __awaiter(this, arguments, void 0, function* (document, position, kind, settings = workspace.settings) {
                var _a, _b;
                const offset = document.offsetAt(position);
                const text = document.getText();
                if (kind === 'autoQuote') {
                    if (offset > 0 && text.charAt(offset - 1) === '=') {
                        const htmlSettings = settings === null || settings === void 0 ? void 0 : settings.html;
                        const options = merge(htmlSettings === null || htmlSettings === void 0 ? void 0 : htmlSettings.suggest, {});
                        options.attributeDefaultValue = (_b = (_a = htmlSettings === null || htmlSettings === void 0 ? void 0 : htmlSettings.completion) === null || _a === void 0 ? void 0 : _a.attributeDefaultValue) !== null && _b !== void 0 ? _b : 'doublequotes';
                        return htmlLanguageService.doQuoteComplete(document, position, htmlDocuments.get(document), options);
                    }
                }
                else if (kind === 'autoClose') {
                    if (offset > 0 && text.charAt(offset - 1).match(/[>\/]/g)) {
                        return htmlLanguageService.doTagComplete(document, position, htmlDocuments.get(document));
                    }
                }
                return null;
            });
        },
        doRename(document, position, newName) {
            return __awaiter(this, void 0, void 0, function* () {
                const htmlDocument = htmlDocuments.get(document);
                return htmlLanguageService.doRename(document, position, newName, htmlDocument);
            });
        },
        onDocumentRemoved(document) {
            return __awaiter(this, void 0, void 0, function* () {
                htmlDocuments.onDocumentRemoved(document);
            });
        },
        findMatchingTagPosition(document, position) {
            return __awaiter(this, void 0, void 0, function* () {
                const htmlDocument = htmlDocuments.get(document);
                return htmlLanguageService.findMatchingTagPosition(document, position, htmlDocument);
            });
        },
        doLinkedEditing(document, position) {
            return __awaiter(this, void 0, void 0, function* () {
                const htmlDocument = htmlDocuments.get(document);
                return htmlLanguageService.findLinkedEditingRanges(document, position, htmlDocument);
            });
        },
        dispose() {
            htmlDocuments.dispose();
        }
    };
}
function merge(src, dst) {
    if (src) {
        for (const key in src) {
            if (src.hasOwnProperty(key)) {
                dst[key] = src[key];
            }
        }
    }
    return dst;
}
