import gettext

def _setup_gettext():
    gettext.bindtextdomain('nautilus-code', '/usr/share/locale')
    gettext.textdomain('nautilus-code')

_setup_gettext()

from gi.repository import Nautilus, GObject
from NautilusCode.program_list import progs


class Extension (GObject.Object, Nautilus.MenuProvider):

    def _get_items (self, folder, *, id_prefix='', is_file=False):
        _setup_gettext()
        folder_path = folder.get_location().get_path()
        return  progs.get_menu_items(folder_path, id_prefix=id_prefix, is_file=is_file)

    def get_background_items (self, *args):
        current_folder = args[-1]
        return self._get_items(current_folder)

    def get_file_items (self, *args):
        selected_files = args[-1]

        if len(selected_files) != 1:
            return
        
        if selected_files[0].is_directory():
            return self._get_items(selected_files[0], id_prefix='selected.')
        else:
            return self._get_items(selected_files[0], id_prefix='selected.', is_file=True)
