class Cmd:
    MAGIC = 0xFEEEEEEF
    SYNC_SIGNAL = 0x434E5953

    UNKNOWN = 0x010000
    DOWNLOAD = 0x010001
    UPLOAD = 0x010002
    FORMAT = 0x010003
    WRITE_DATA = 0x010004
    READ_DATA = 0x010005
    FORMAT_PARTITION = 0x010006
    SHUTDOWN = 0x010007
    BOOT_TO = 0x010008
    DEVICE_CTRL = 0x010009
    INIT_EXT_RAM = 0x01000A
    SWITCH_USB_SPEED = 0x01000B
    READ_OTP_ZONE = 0x01000C
    WRITE_OTP_ZONE = 0x01000D
    WRITE_EFUSE = 0x01000E
    READ_EFUSE = 0x01000F
    NAND_BMT_REMARK = 0x010010
    SETUP_ENVIRONMENT = 0x010100
    SETUP_HW_INIT_PARAMS = 0x010101

    SET_BMT_PERCENTAGE = 0x020001
    SET_BATTERY_OPT = 0x020002
    SET_CHECKSUM_LEVEL = 0x020003
    SET_RESET_KEY = 0x020004
    SET_HOST_INFO = 0x020005
    SET_META_BOOT_MODE = 0x020006
    SET_EMMC_HWRESET_PIN = 0x020007
    SET_GENERATE_GPX = 0x020008
    SET_REGISTER_VALUE = 0x020009
    SET_EXTERNAL_SIG = 0x02000A
    SET_REMOTE_SEC_POLICY = 0x02000B
    SET_ALL_IN_ONE_SIG = 0x02000C
    SET_RSC_INFO = 0x02000D
    SET_UPDATE_FW = 0x020010
    SET_UFS_CONFIG = 0x020011

    GET_EMMC_INFO = 0x040001
    GET_NAND_INFO = 0x040002
    GET_NOR_INFO = 0x040003
    GET_UFS_INFO = 0x040004
    GET_DA_VERSION = 0x040005
    GET_EXPIRE_DATA = 0x040006
    GET_PACKET_LENGTH = 0x040007
    GET_RANDOM_ID = 0x040008
    GET_PARTITION_TBL_CATA = 0x040009
    GET_CONNECTION_AGENT = 0x04000A
    GET_USB_SPEED = 0x04000B
    GET_RAM_INFO = 0x04000C
    GET_CHIP_ID = 0x04000D
    GET_OTP_LOCK_STATUS = 0x04000E
    GET_BATTERY_VOLTAGE = 0x04000F
    GET_RPMB_STATUS = 0x040010
    GET_EXPIRE_DATE = 0x040011
    GET_DRAM_TYPE = 0x040012
    GET_DEV_FW_INFO = 0x040013
    GET_HRID = 0x040014
    GET_ERROR_DETAIL = 0x040015
    SLA_ENABLED_STATUS = 0x040016

    START_DL_INFO = 0x080001
    END_DL_INFO = 0x080002
    ACT_LOCK_OTP_ZONE = 0x080003
    DISABLE_EMMC_HWRESET_PIN = 0x080004
    CC_OPTIONAL_DOWNLOAD_ACT = 0x800005
    DA_STOR_LIFE_CYCLE_CHECK = 0x080007

    UNKNOWN_CTRL_CODE = 0x0E0000
    CTRL_STORAGE_TEST = 0x0E0001
    CTRL_RAM_TEST = 0x0E0002
    DEVICE_CTRL_READ_REGISTER = 0x0E0003


class ChecksumAlgorithm:
    PLAIN = 0
    CRC32 = 1
    MD5 = 2


class FtSystemOSE:
    OS_WIN = 0
    OS_LINUX = 1


class DataType:
    DT_PROTOCOL_FLOW = 1
    DT_MESSAGE = 2
