/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext;

import java.io.IOException;
import jfx.incubator.scene.control.richtext.model.StyledOutput;
import jfx.incubator.scene.control.richtext.model.StyledSegment;

public class StringBuilderStyledOutput
implements StyledOutput {
    private final StringBuilder sb;
    private String newline = System.getProperty("line.separator");

    public StringBuilderStyledOutput(int n) {
        this.sb = new StringBuilder(n);
    }

    public StringBuilderStyledOutput() {
        this(1024);
    }

    public void setLineSeparator(String string) {
        this.newline = string;
    }

    @Override
    public void consume(StyledSegment styledSegment) {
        switch (styledSegment.getType()) {
            case LINE_BREAK: {
                this.sb.append(this.newline);
                break;
            }
            case TEXT: {
                String string = styledSegment.getText();
                this.sb.append(string);
            }
        }
    }

    public String toString() {
        return this.sb.toString();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}

