/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.util;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLNode {
    private final Map<String, String> m_Attributes;
    private final List<XMLNode> m_SubNodes;
    private final String m_Name;

    public XMLNode(String name) {
        this.m_Name = name;
        this.m_Attributes = new LinkedHashMap<String, String>();
        this.m_SubNodes = new LinkedList<XMLNode>();
    }

    public void addNode(XMLNode node) {
        this.m_SubNodes.add(node);
    }

    public String getName() {
        return this.m_Name;
    }

    public List<XMLNode> getAllNodes(String name) {
        LinkedList<XMLNode> list = new LinkedList<XMLNode>();
        for (XMLNode n : this.m_SubNodes) {
            if (!n.getName().equals(name)) continue;
            list.add(n);
        }
        return list;
    }

    public String getAttribute(String name) {
        return this.m_Attributes.get(name);
    }

    public void setAttribute(String name, String value) {
        this.m_Attributes.put(name, value);
    }

    public String toXMLString() {
        StringBuilder text = new StringBuilder();
        text.append("<" + this.m_Name);
        for (String key : this.m_Attributes.keySet()) {
            String value = this.m_Attributes.get(key);
            if (value == null) {
                text.append(" " + key);
                continue;
            }
            text.append(" " + key + "=\"" + XMLNode.ConvertTextToXml(value) + "\"");
        }
        if (this.m_SubNodes.size() > 0) {
            text.append(">");
            for (XMLNode n : this.m_SubNodes) {
                text.append(n.toXMLString());
            }
            text.append("</" + this.m_Name + ">");
        } else {
            text.append("/>");
        }
        return text.toString();
    }

    public static String ConvertTextToXml(String s) {
        if (s.indexOf("&") > -1) {
            s = s.replaceAll("\\&", "&amp;");
        }
        if (s.indexOf("\"") > -1) {
            s = s.replaceAll("\\\"", "&quot;");
        }
        if (s.indexOf("<") > -1) {
            s = s.replaceAll("\\<", "&lt;");
        }
        if (s.indexOf(">") > -1) {
            s = s.replaceAll("\\>", "&gt;");
        }
        return s;
    }

    public static String htmlDecode(String s) {
        s = s.replaceAll("\\&amp;", "&");
        s = s.replaceAll("\\&quot;", "\"");
        s = s.replaceAll("\\&nbsp;", " ");
        s = s.replaceAll("\\&lt;", "<");
        s = s.replaceAll("\\&gt;", ">");
        return s;
    }

    public static XMLNode fromElement(Element element) {
        XMLNode result = new XMLNode(element.getTagName());
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr a = (Attr)attrs.item(i);
            result.setAttribute(a.getName(), a.getValue());
        }
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (!(n instanceof Element)) continue;
            XMLNode node2 = XMLNode.fromElement((Element)n);
            result.addNode(node2);
        }
        return result;
    }

    private static XMLNode parseTag(String tag, XMLNode node) {
        char[] ca = tag.toCharArray();
        int pos = 0;
        for (int i = 0; i < ca.length; ++i) {
            if (node == null && (ca[i] == ' ' || i == ca.length - 1)) {
                node = new XMLNode(new String(ca, 0, i + 1).trim());
                pos = i + 1;
                continue;
            }
            if ((ca[i] != ' ' || ca[i - 1] != '\"') && i != ca.length - 1) continue;
            String attrib = new String(ca, pos, i - pos + 1).trim();
            int pos2 = attrib.indexOf(61);
            if (pos2 > -1) {
                String key = attrib.substring(0, pos2);
                String val = attrib.substring(pos2 + 1, attrib.length());
                if (val.startsWith("\"")) {
                    val = val.substring(1, val.length());
                }
                if (val.endsWith("\"")) {
                    val = val.substring(0, val.length() - 1);
                }
                node.m_Attributes.put(key, val);
            } else {
                node.m_Attributes.put(attrib, null);
            }
            pos = i + 1;
        }
        return node;
    }

    public static XMLNode parse(String xml) {
        String s1 = "";
        String s2 = "";
        if (xml.endsWith("/>")) {
            s1 = xml.substring(1, xml.length() - 2);
        } else {
            int pos = xml.indexOf(">");
            s1 = xml.substring(1, pos);
            s2 = xml.substring(pos + 1).trim();
            pos = s2.lastIndexOf("</");
            s2 = s2.substring(0, pos);
        }
        XMLNode node = XMLNode.parseTag(s1.trim(), null);
        char[] ca = s2.toCharArray();
        int iLevel = 0;
        StringBuilder tmp = new StringBuilder();
        boolean b = false;
        for (int i = 0; i < ca.length; ++i) {
            tmp.append(ca[i]);
            if (ca[i] == '<' && ca[i + 1] != '/') {
                ++iLevel;
                continue;
            }
            if (ca[i] == '<' && ca[i + 1] == '/') {
                b = true;
                continue;
            }
            if (ca[i] != '>') continue;
            if (ca[i - 1] == '/') {
                --iLevel;
            } else if (b) {
                b = false;
                --iLevel;
            }
            if (iLevel != 0) continue;
            node.m_SubNodes.add(XMLNode.parse(tmp.toString()));
            tmp = new StringBuilder();
        }
        return node;
    }

    public String toString() {
        return this.toXMLString();
    }
}

