/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.util;

import com.ddfplus.db.SymbolInfo;
import java.text.NumberFormat;

public final class ParserHelper {
    public static final int DDFAPI_NOVALUE = 0;
    public static final int DECIMAL = 0;
    public static final int PURE_DECIMAL = 3;
    public static final int DASH = 1;
    public static final int INTEGER = 2;
    private static final int[] units_f1 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000};
    private static final int[] units_f2 = new int[]{8, 16, 32, 64, 128, 256, 512};
    private static final int[] units_f3 = new int[]{8, 16, 32, 64, 128, 256, 512};
    private static final int[] units_f4 = new int[]{10, 100, 100, 100, 1000, 1000, 1000};
    private static final NumberFormat NF = NumberFormat.getInstance();

    public static int float2int(int basecode, float value) {
        int n;
        byte tmp;
        float c = value;
        float rf = 0.25f;
        if (c < 0.0f) {
            rf = -0.25f;
        }
        if ((tmp = (byte)basecode) >= 0) {
            float d = c * (float)units_f1[tmp] + rf;
            return (int)d;
        }
        int i = 0 - basecode - 1;
        int ii = units_f3[i];
        int jj = units_f4[i];
        float dd = 1.0f / (float)units_f2[i];
        float t = ParserHelper.roundFloat(c, dd);
        int j = (int)((t - (float)(n = (int)t)) * (float)ii + rf);
        if (j >= ii) {
            j = jj;
        }
        return n * jj + j;
    }

    public static final String float2string(float f, char basecode, int target) {
        return ParserHelper.float2string(f, basecode, target, true);
    }

    public static final synchronized String float2string(double value, char basecode, int target, boolean special64) {
        int unit = SymbolInfo.ddfuc2bb(basecode);
        if (unit >= 0) {
            if (target == 3) {
                NF.setGroupingUsed(false);
            } else {
                NF.setGroupingUsed(true);
            }
            NF.setMinimumFractionDigits(unit);
            NF.setMaximumFractionDigits(unit);
            Object s = NF.format(value);
            if (target == 2) {
                int i;
                char[] ca = ((String)s).toCharArray();
                int st = 0;
                s = "";
                for (i = 0; i < ca.length; ++i) {
                    if (i == 0 && ca[i] == '+' || ca[i] == '-') {
                        ++st;
                        continue;
                    }
                    if (ca[i] == '0' || ca[i] == '.') {
                        ++st;
                        continue;
                    }
                    if (Character.isDigit(ca[i])) break;
                }
                for (i = st; i < ca.length; ++i) {
                    if (!Character.isDigit(ca[i])) continue;
                    s = (String)s + ca[i];
                }
                if (value == 0.0 && ((String)s).length() < 1) {
                    s = "0";
                }
                if (value < 0.0) {
                    s = "-" + (String)s;
                }
                return s;
            }
            return s;
        }
        if (target == 0 || target == 3) {
            if (target == 3) {
                NF.setGroupingUsed(false);
            } else {
                NF.setGroupingUsed(true);
            }
            switch (unit) {
                case -1: {
                    NF.setMinimumFractionDigits(3);
                    NF.setMaximumFractionDigits(3);
                    break;
                }
                case -2: {
                    NF.setMinimumFractionDigits(4);
                    NF.setMaximumFractionDigits(4);
                    break;
                }
                case -3: {
                    NF.setMinimumFractionDigits(5);
                    NF.setMaximumFractionDigits(5);
                    break;
                }
                case -4: {
                    NF.setMinimumFractionDigits(6);
                    NF.setMaximumFractionDigits(6);
                    break;
                }
                case -5: {
                    NF.setMinimumFractionDigits(7);
                    NF.setMaximumFractionDigits(7);
                    break;
                }
                case -6: {
                    NF.setMinimumFractionDigits(8);
                    NF.setMaximumFractionDigits(8);
                }
            }
            return NF.format(value);
        }
        int sign = 1;
        if (value < 0.0) {
            sign = -1;
        }
        value = Math.abs(value);
        int iWhole = (int)value;
        String sw = "" + iWhole;
        if (sign == -1) {
            sw = "-" + sw;
        }
        Object sf = "";
        double div = value - (double)((int)value);
        int digits = 0;
        if (unit == -1) {
            div *= 8.0;
            digits = 1;
        } else if (unit == -2) {
            div *= 16.0;
            digits = 2;
        } else if (unit == -3) {
            div *= 32.0;
            digits = 2;
        } else if (unit == -4) {
            if (special64) {
                div *= 320.0;
                digits = 3;
            } else {
                div *= 64.0;
                digits = 2;
            }
        } else if (unit == -5) {
            if (special64) {
                div *= 320.0;
                digits = 3;
            } else {
                div *= 128.0;
                digits = 3;
            }
        } else if (unit == -6) {
            div *= 256.0;
            digits = 3;
        } else {
            div = 0.0;
            digits = 1;
        }
        sf = "00000000" + (int)div;
        sf = ((String)sf).substring(((String)sf).length() - digits, ((String)sf).length());
        if (target == 2) {
            if (iWhole != 0) {
                return sw + (String)sf;
            }
            char c = sw.charAt(0);
            if (c == '-') {
                return c + (String)sf;
            }
            return sf;
        }
        return sw + "-" + (String)sf;
    }

    public static float roundFloat(float r, float rinc) {
        float t = rinc;
        if (r < 0.0f) {
            t = -rinc;
        }
        t = (r + t / 2.0f) / rinc;
        int i = (int)t;
        float d = rinc * (float)i;
        return d;
    }

    public static float string2float(String value, char unitcode) throws NumberFormatException {
        return ParserHelper.string2float(value, SymbolInfo.ddfuc2bb(unitcode));
    }

    public static float string2float(String value, int basecode) throws NumberFormatException {
        if (value.length() == 0) {
            return 0.0f;
        }
        if (value.equals("-")) {
            return 0.0f;
        }
        int ival = Integer.parseInt(value);
        float f = 0.0f;
        if (basecode >= 0) {
            f = (float)ival / (float)Math.pow(10.0, basecode);
        } else {
            switch (basecode) {
                case -1: {
                    f = (float)(ival / 10) + (float)(ival % 10) / 8.0f;
                    break;
                }
                case -2: {
                    f = (float)(ival / 100) + (float)(ival % 100) / 16.0f;
                    break;
                }
                case -3: {
                    f = (float)(ival / 100) + (float)(ival % 100) / 32.0f;
                    break;
                }
                case -4: {
                    f = (float)(ival / 100) + (float)(ival % 100) / 64.0f;
                    break;
                }
                case -5: {
                    f = (float)(ival / 1000) + (float)(ival % 1000) / 128.0f;
                    break;
                }
                case -6: {
                    f = (float)(ival / 1000) + (float)(ival % 1000) / 256.0f;
                }
            }
        }
        return f;
    }

    public static int string2int(String value) {
        int i = 0;
        if (value.length() == 0) {
            return 0;
        }
        try {
            i = Integer.parseInt(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public static boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && c != '\uffff' && block != null && block != Character.UnicodeBlock.SPECIALS;
    }

    public static final char filterNullChar(char in) {
        if (in == '\u0000') {
            return '?';
        }
        return in;
    }

    public static final String toAsciiString(byte[] bytes) {
        int size = bytes.length;
        char[] charArray = new char[size];
        for (int k = 0; k < size; ++k) {
            int c = bytes[k];
            charArray[k] = ParserHelper.isPrintableChar((char)c) ? c : 32;
        }
        return new String(charArray);
    }

    public static final String toAsciiString2(byte[] bytes) {
        int size = bytes.length;
        char[] charArray = new char[size * 2];
        int m = 0;
        for (int k = 0; k < size; ++k) {
            int c = bytes[k];
            charArray[m++] = 32;
            charArray[m++] = ParserHelper.isPrintableChar((char)c) ? c : 32;
        }
        return new String(charArray);
    }

    public static final String toHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int size = bytes.length;
        for (int k = 0; k < size; ++k) {
            byte high = (byte)((bytes[k] & 0xF0) >> 4);
            byte low = (byte)(bytes[k] & 0xF);
            sb.append(ParserHelper.nibble2char(high));
            sb.append(ParserHelper.nibble2char(low));
        }
        return sb.toString();
    }

    private static final char nibble2char(byte b) {
        byte nibble = (byte)(b & 0xF);
        if (nibble < 10) {
            return (char)(48 + nibble);
        }
        return (char)(97 + nibble - 10);
    }
}

