/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.util;

import com.ddfplus.util.MessageStore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageStoreImpl
implements MessageStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private DataInputStream in;
    private DataOutputStream out;
    private String filePath;

    @Override
    public void open(String filePath, boolean read) {
        this.filePath = filePath;
        try {
            this.log.info("Opening up message store: " + filePath);
            if (read) {
                FileInputStream fis = new FileInputStream(filePath);
                this.in = new DataInputStream(fis);
            } else {
                FileOutputStream fos = new FileOutputStream(filePath);
                this.out = new DataOutputStream(fos);
            }
        }
        catch (FileNotFoundException e) {
            this.log.error("Could not create message store: " + e);
        }
    }

    @Override
    public void open(String path, String fileName, boolean read) {
        this.open(path + "/" + fileName, read);
    }

    @Override
    public void close() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void storeMessage(byte[] bytes) {
        try {
            this.out.writeInt(bytes.length);
            this.out.write(bytes);
        }
        catch (IOException e) {
            this.log.error("Could not write to message store: " + e);
        }
    }

    @Override
    public void readMessages(MessageStore.ReaderCallback cb) {
        if (this.in == null) {
            this.log.error("Message store was not opened");
            return;
        }
        if (cb == null) {
            this.log.error("Reader callback cannot be null");
            return;
        }
        byte[] buf = new byte[1024];
        try {
            while (this.in.available() > 0) {
                int len = this.in.readInt();
                if (buf.length < len) {
                    buf = new byte[len];
                }
                this.in.read(buf, 0, len);
                cb.onMessage(buf, len);
            }
        }
        catch (IOException e) {
            this.log.error("Read error on: " + this.filePath + " error: " + e.getMessage());
        }
    }
}

