/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class DDFDate {
    public static final ZoneId _zoneChicago = ZoneId.of("America/Chicago");
    private static final DateTimeFormatter _formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(_zoneChicago);
    private static final DateTimeFormatter _formatterOhlc = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm").withZone(_zoneChicago);
    private final ZonedDateTime _zdt;
    private final char _dayCode;

    public DDFDate(ZonedDateTime zdt) {
        this._zdt = zdt;
        this._dayCode = DDFDate.convertNumberToDayCode(this._zdt.getDayOfMonth());
    }

    public DDFDate(long millis) {
        this._zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), _zoneChicago);
        this._dayCode = DDFDate.convertNumberToDayCode(this._zdt.getDayOfMonth());
    }

    public ZonedDateTime getDate() {
        return this._zdt;
    }

    public char getDayCode() {
        return this._dayCode;
    }

    public long getMillisCST() {
        return this._zdt.withZoneSameInstant(_zoneChicago).toInstant().toEpochMilli();
    }

    public String toDDFString() {
        return this._zdt.format(_formatter);
    }

    public String toString() {
        return Long.toString(this._zdt.toInstant().toEpochMilli());
    }

    public static int convertDayCodeToNumber(char daycode) {
        if (daycode == '\u0000') {
            return 0;
        }
        if (daycode >= '1' && daycode <= '9') {
            return daycode - 48;
        }
        if (daycode == '0') {
            return 10;
        }
        return daycode - 65 + 11;
    }

    public static char convertNumberToDayCode(int value) {
        if (value >= 1 && value <= 9) {
            return (char)(49 + value - 1);
        }
        if (value == 10) {
            return '0';
        }
        return (char)(65 + value - 11);
    }

    public static DDFDate fromDayCode(char daycode) {
        boolean minusMonth;
        int day = DDFDate.convertDayCodeToNumber(daycode);
        if (day < 1 || day > 31) {
            return null;
        }
        ZonedDateTime zdt = ZonedDateTime.now(_zoneChicago);
        boolean plusMonth = day < zdt.getDayOfMonth() - 25;
        boolean bl = minusMonth = day > zdt.getDayOfMonth() + 5;
        if (plusMonth) {
            zdt = zdt.plusMonths(1L);
        } else if (minusMonth) {
            zdt = zdt.minusMonths(1L);
        }
        zdt = zdt.withDayOfMonth(day);
        return new DDFDate(zdt);
    }

    public static DDFDate fromDDFString(String s) {
        try {
            ZonedDateTime zdt = ZonedDateTime.parse(s, _formatter);
            return new DDFDate(zdt);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static DDFDate fromDDFStringOhlc(String s) {
        try {
            ZonedDateTime zdt = ZonedDateTime.parse(s, _formatterOhlc);
            return new DDFDate(zdt);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

