/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.service.usersettings;

import com.ddfplus.service.usersettings.UserSettings;
import com.ddfplus.service.usersettings.UserSettingsService;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UserSettingsServiceImpl
implements UserSettingsService {
    public static final String DDF_CENTRAL = "http://www.ddfplus.com";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String queryUrl;

    @Override
    public UserSettings getUserSettings(String userName, String password) {
        UserSettings userSettings = new UserSettings();
        userSettings.setUserName(userName);
        userSettings.setPassword(password);
        String url = this.getURL(userName, password);
        try {
            NodeList serverList;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(url);
            Element userSettingsElement = doc.getDocumentElement();
            NodeList childrenList = userSettingsElement.getChildNodes();
            Node serversNode = null;
            if (childrenList != null) {
                for (int i = 0; i < childrenList.getLength(); ++i) {
                    Node child = childrenList.item(i);
                    if (!child.getNodeName().equals("servers")) continue;
                    serversNode = child;
                    break;
                }
            }
            if (serversNode != null && (serverList = serversNode.getChildNodes()) != null) {
                for (int i = 0; i < serverList.getLength(); ++i) {
                    Node type;
                    Node server = serverList.item(i);
                    NamedNodeMap attributes = server.getAttributes();
                    if (attributes == null || !(type = attributes.getNamedItem("type")).getTextContent().equals("stream")) continue;
                    Node n = attributes.getNamedItem("primary");
                    if (n != null) {
                        userSettings.setStreamPrimaryServer(n.getTextContent());
                    }
                    if ((n = attributes.getNamedItem("secondary")) != null) {
                        userSettings.setStreamSecondaryServer(n.getTextContent());
                    }
                    if ((n = attributes.getNamedItem("recovery")) != null) {
                        userSettings.setRecoveryServer(n.getTextContent());
                    }
                    if ((n = attributes.getNamedItem("wss")) == null) continue;
                    userSettings.setWssServer(n.getTextContent());
                }
            }
            this.log.info("User settings: " + userSettings);
        }
        catch (ParserConfigurationException e) {
            this.log.error("User settings parse configuration: " + e.getMessage());
        }
        catch (SAXException e) {
            this.log.error("User settings parse: " + e.getMessage());
        }
        catch (IOException e) {
            this.log.error("User settings IO issue: " + e.getMessage());
        }
        return userSettings;
    }

    void setQueryUrl(String url) {
        this.queryUrl = url;
    }

    private String getURL(String userName, String password) {
        if (this.queryUrl != null) {
            return this.queryUrl;
        }
        return "http://www.ddfplus.com/getUserSettings.php?username=" + userName + "&password=" + password;
    }
}

