/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.service.feed;

import com.ddfplus.api.QuoteHandler;
import com.ddfplus.db.DataMaster;
import com.ddfplus.db.Quote;
import com.ddfplus.service.feed.FeedService;
import com.ddfplus.service.usersettings.UserSettings;
import com.ddfplus.util.XMLNode;
import com.ddfplus.util.XmlUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FeedServiceImpl
implements FeedService {
    private static final int REQUEST_THREAD_INITIAL_DELAY_MS = 100;
    private static final long REQUEST_THREAD_TIMEOUT_MS = 500L;
    private static final int REQUEST_MAX_SYMBOLS = 200;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final UserSettings userSettings;
    private final String baseUrl;
    private DataMaster datamaster;
    private BlockingQueue<FeedCmd> requestQ = new LinkedBlockingQueue<FeedCmd>(100);
    private ScheduledExecutorService es = Executors.newScheduledThreadPool(1);
    private RequestThread requestThread;
    private Map<String, QuoteHandler> quoteExchangehandlers;
    private String queryUrl;

    public FeedServiceImpl(DataMaster datamaster, UserSettings userSettings) {
        this(datamaster, userSettings, null);
    }

    public FeedServiceImpl(DataMaster datamaster, UserSettings userSettings, Map<String, QuoteHandler> quoteExchangehandlers) {
        this.datamaster = datamaster;
        this.userSettings = userSettings;
        this.quoteExchangehandlers = quoteExchangehandlers;
        this.baseUrl = this.buildBaseUrl(this.userSettings);
        this.requestThread = new RequestThread(this.requestQ);
        this.es.scheduleAtFixedRate(this.requestThread, 100L, 500L, TimeUnit.MILLISECONDS);
        this.log.info("Snapshot/Refresh is enabled for user: " + userSettings.getUserName());
    }

    @Override
    public void scheduleQuoteRefresh(String symbol) {
        FeedCmd cmd = new FeedCmd(CMDS.QuoteRefresh, symbol);
        this.requestQ.offer(cmd);
    }

    void getQuotes(List<String> symbolList) {
        String query = this.buildQueryString(symbolList);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending refresh request: " + query);
        }
        try {
            Node node;
            int i;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(query);
            if (this.log.isDebugEnabled()) {
                this.log.debug(XmlUtil.printDocument(doc));
            }
            Element root = doc.getDocumentElement();
            NodeList list = root.getElementsByTagName("QUOTE");
            for (i = 0; i < list.getLength(); ++i) {
                try {
                    String ddfExchange;
                    QuoteHandler eh;
                    node = list.item(i);
                    XMLNode n = XMLNode.fromElement((Element)node);
                    Quote q = Quote.fromXMLNode(n);
                    this.datamaster.putQuote(q);
                    if (this.quoteExchangehandlers == null || (eh = this.quoteExchangehandlers.get(ddfExchange = q.getDDFExchange())) == null) continue;
                    eh.onQuote(q);
                    continue;
                }
                catch (Exception e2) {
                    this.log.error("Parsing Quote Error: " + e2.getMessage());
                }
            }
            list = root.getElementsByTagName("BOOK");
            list = root.getElementsByTagName("CV");
            for (i = 0; i < list.getLength(); ++i) {
                try {
                    node = list.item(i);
                    this.processCV(node);
                    continue;
                }
                catch (Exception e2) {
                    this.log.error("CV Parsing Error: " + e2.getMessage());
                }
            }
        }
        catch (ParserConfigurationException e) {
            this.log.error("Parser configuration on snapshot/refresh request: " + e.getMessage());
        }
        catch (SAXException e) {
            this.log.error("Could not parse snapshot/refresh request: " + e.getMessage());
        }
        catch (IOException e) {
            this.log.error("IO issue with snaphost/refresh request: " + e.getMessage());
        }
    }

    private void processCV(Node node) {
    }

    private String buildQueryString(List<String> symbols) {
        if (this.queryUrl != null) {
            return this.queryUrl;
        }
        StringBuilder sb = new StringBuilder(this.baseUrl);
        for (int i = 0; i < symbols.size(); ++i) {
            try {
                String s = symbols.get(i);
                s = s.replaceAll("\\s+", "");
                if (i == 0) {
                    sb.append(URLEncoder.encode(s, "UTF-8"));
                    continue;
                }
                sb.append(",").append(URLEncoder.encode(s, "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                this.log.error("URL encode error: ", (Throwable)e);
            }
        }
        return sb.toString();
    }

    private String buildBaseUrl(UserSettings us) {
        String s = us.getStreamPrimaryServer();
        return "http://" + s + "/stream/quotes.jsx?username=" + us.getUserName() + "&password=" + us.getPassword() + "&symbols=";
    }

    void setQueryUrl(String url) {
        this.queryUrl = url;
    }

    private class RequestThread
    implements Runnable {
        private BlockingQueue<FeedCmd> cmdQ;
        private List<String> symbols = new ArrayList<String>();

        public RequestThread(BlockingQueue<FeedCmd> q) {
            this.cmdQ = FeedServiceImpl.this.requestQ;
        }

        @Override
        public void run() {
            this.symbols.clear();
            while (this.cmdQ.peek() != null) {
                try {
                    FeedCmd cmd = (FeedCmd)this.cmdQ.poll();
                    if (cmd == null) continue;
                    switch (cmd.getCmd()) {
                        case QuoteRefresh: {
                            if (this.symbols.size() < 200) {
                                this.symbols.add(cmd.getSymbol());
                                break;
                            }
                            FeedServiceImpl.this.getQuotes(this.symbols);
                            this.symbols.clear();
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    FeedServiceImpl.this.log.error("Feed request error: " + e.getMessage());
                }
            }
            if (this.symbols.size() > 0) {
                FeedServiceImpl.this.getQuotes(this.symbols);
            }
        }
    }

    private static class FeedCmd {
        private CMDS cmd;
        private String symbol;

        public FeedCmd(CMDS cmd, String symbol) {
            this.cmd = cmd;
            this.symbol = symbol;
        }

        public CMDS getCmd() {
            return this.cmd;
        }

        public void setCmd(CMDS cmd) {
            this.cmd = cmd;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public void setSymbol(String symbols) {
            this.symbol = symbols;
        }
    }

    private static enum CMDS {
        QuoteRefresh;

    }
}

