/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.service.definition;

import com.ddfplus.service.definition.DefinitionService;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefinitionServiceImpl
implements DefinitionService {
    private static final int DEFAULT_DEFINITION_REFRESH_INTERVAL_SEC = 43200;
    private static final int NEAREST_MONTH = 0;
    private static final String BASE_URL = "http://extras.ddfplus.com/json/";
    private static final String FUTURES_URL = "http://extras.ddfplus.com/json//futures/?root=";
    private static final String OPTIONS_URL = "http://extras.ddfplus.com/json//options/?root=";
    private static final String EXCHANGE_SYMBOLS_URL = "http://extras.ddfplus.com/json//instruments?exchange=";
    private static final Logger logger = LoggerFactory.getLogger((String)"DefinitionService");
    private final Map<String, FuturesRoot> futureRoots = new ConcurrentHashMap<String, FuturesRoot>();
    private final Map<String, OptionsRoot> optionsRoots = new ConcurrentHashMap<String, OptionsRoot>();
    private final Map<String, List<String>> exchangeSymbols = new ConcurrentHashMap<String, List<String>>();
    private final Map<String, String> symbolToExchange = new ConcurrentHashMap<String, String>();
    private final Gson gson;
    private OkHttpClient httpClient;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private long refreshIntervalSec = 43200L;

    public DefinitionServiceImpl() {
        this.httpClient = new OkHttpClient();
        this.httpClient.setConnectTimeout(3L, TimeUnit.SECONDS);
        this.httpClient.setReadTimeout(20L, TimeUnit.SECONDS);
        this.gson = new GsonBuilder().create();
    }

    @Override
    public void init(Long intervalSec) {
        if (intervalSec != null) {
            this.refreshIntervalSec = intervalSec;
        }
        logger.info("Scheduling a symbol refresh every " + this.refreshIntervalSec + " seconds.");
        RefreshThread refreshThread = new RefreshThread();
        this.scheduler.scheduleAtFixedRate(refreshThread, this.refreshIntervalSec, this.refreshIntervalSec, TimeUnit.SECONDS);
    }

    @Override
    public String[] getAllFutureSymbols(String root) {
        String[] futures = new String[]{};
        FuturesRoot futureRoot = this.futureRoots.get(root);
        if (futureRoot == null) {
            futureRoot = this.buildFutureContractCache(root);
        }
        if (futureRoot != null) {
            futures = futureRoot.getContractSymbols();
        }
        return futures;
    }

    @Override
    public String getFuturesMonthSymbol(String root, int month) {
        String ret = null;
        FuturesRoot futureRoot = this.futureRoots.get(root);
        if (futureRoot == null) {
            futureRoot = this.buildFutureContractCache(root);
        }
        if (futureRoot != null) {
            if (month == 0) {
                return futureRoot.getNearestContract().getSymbol();
            }
            return futureRoot.getSymbolByMonth(month);
        }
        return ret;
    }

    @Override
    public String[] getAllOptionsSymbols(String root) {
        String[] options = new String[]{};
        OptionsRoot optionsRoot = this.optionsRoots.get(root);
        if (optionsRoot == null) {
            optionsRoot = this.buildOptionsContractCache(root);
        }
        if (optionsRoot != null) {
            options = optionsRoot.getAllStrikeSymbols();
        }
        return options;
    }

    @Override
    public String[] getAllOptionsMonthYearSymbols(String root, String monthYear) {
        String[] options = new String[]{};
        OptionsRoot optionsRoot = this.optionsRoots.get(root);
        if (optionsRoot == null) {
            optionsRoot = this.buildOptionsContractCache(root);
        }
        if (optionsRoot != null) {
            options = optionsRoot.getMonthYearStrikeSymbols(monthYear);
        }
        return options;
    }

    @Override
    public String[] getExchangeSymbols(String exchangeCode) {
        return this.lookUpExchangeSymbols(exchangeCode, false);
    }

    private String[] lookUpExchangeSymbols(String exchangeCode, boolean refresh) {
        List<String> symbols = this.exchangeSymbols.get(exchangeCode);
        if (refresh || symbols == null || symbols.size() == 0) {
            Request request = new Request.Builder().url(EXCHANGE_SYMBOLS_URL + exchangeCode).build();
            try {
                Response response = this.httpClient.newCall(request).execute();
                if (response.isSuccessful()) {
                    String json = response.body().string();
                    logger.debug("< {}", (Object)json);
                    Type listType = new TypeToken<List<InstrumentDefinition>>(){}.getType();
                    List defs = (List)this.gson.fromJson(json, listType);
                    logger.info("Received {} symbols for exchange {}", (Object)defs.size(), (Object)exchangeCode);
                    symbols = new ArrayList<String>();
                    for (InstrumentDefinition def : defs) {
                        symbols.add(def.getSymbol_ddf());
                        this.symbolToExchange.put(def.getSymbol_ddf(), exchangeCode);
                    }
                    this.exchangeSymbols.put(exchangeCode, symbols);
                }
            }
            catch (Exception e) {
                logger.error("Could not obtain symbols for exchange: {} error: {}", (Object)exchangeCode, (Object)e.getMessage());
            }
        }
        return symbols.toArray(new String[symbols.size()]);
    }

    @Override
    public String getExchange(String symbol) {
        return this.symbolToExchange.get(symbol);
    }

    private FuturesRoot buildFutureContractCache(String root) {
        FuturesRoot futureRoot = null;
        Request request = new Request.Builder().url(FUTURES_URL + root).build();
        try {
            Response response = this.httpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                String json = response.body().string();
                if (logger.isDebugEnabled()) {
                    logger.debug("< " + json);
                }
                futureRoot = this.processFutureRoot(json, root);
            }
        }
        catch (Exception e) {
            logger.error("Could not obtain futures definitions for: " + root + " error: " + e.getMessage());
        }
        return futureRoot;
    }

    FuturesRoot processFutureRoot(String json, String root) {
        FuturesRoot futureRoot = null;
        Type collectionType = new TypeToken<Map<String, FuturesRoot>>(){}.getType();
        Map o = (Map)this.gson.fromJson(json, collectionType);
        if (o != null) {
            futureRoot = (FuturesRoot)o.get(root);
        }
        if (futureRoot == null) {
            logger.error("Could not find futures for root: " + root);
            return futureRoot;
        }
        for (FutureContract contract : futureRoot.getContracts()) {
            if (contract.isnearest) {
                futureRoot.setNearestContract(contract);
            }
            String s = root + contract.getMonth() + contract.getYear().substring(contract.getYear().length() - 1);
            contract.setSymbol(s);
            futureRoot.addContractSymbol(s);
        }
        if (logger.isInfoEnabled()) {
            logger.info(futureRoot.toString());
        }
        this.futureRoots.put(root, futureRoot);
        return futureRoot;
    }

    private OptionsRoot buildOptionsContractCache(String root) {
        OptionsRoot optionsRoot = null;
        Request request = new Request.Builder().url(OPTIONS_URL + root).build();
        try {
            Response response = this.httpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                String json = response.body().string();
                if (logger.isDebugEnabled()) {
                    logger.debug("< " + json);
                }
                optionsRoot = this.processOptionsRoot(json, root);
            }
        }
        catch (Exception e) {
            logger.error("Could not obtain futures definitions for: " + root + " error: " + e.getMessage());
        }
        return optionsRoot;
    }

    OptionsRoot processOptionsRoot(String json, String root) {
        OptionsRoot optionsRoot = null;
        Type collectionType = new TypeToken<Map<String, OptionsRoot>>(){}.getType();
        Map o = (Map)this.gson.fromJson(json, collectionType);
        optionsRoot = (OptionsRoot)o.get(root);
        if (optionsRoot != null) {
            optionsRoot.setRoot(root);
            this.optionsRoots.put(root, optionsRoot);
            if (logger.isInfoEnabled()) {
                logger.info(optionsRoot.toString());
            }
        } else {
            logger.error("Could not find options for root: " + root);
        }
        return optionsRoot;
    }

    public FuturesRoot getFuturesRoot(String root) {
        return this.futureRoots.get(root);
    }

    public OptionsRoot getOptionsRoot(String root) {
        return this.optionsRoots.get(root);
    }

    public long getRefreshPeriodSec() {
        return this.refreshIntervalSec;
    }

    public void setRefreshPeriodSec(long refreshPeriodSec) {
        this.refreshIntervalSec = refreshPeriodSec;
    }

    static class OptionsRoot
    extends LinkedHashMap<String, OptionMonthYear> {
        private String root;

        OptionsRoot() {
        }

        public String getRoot() {
            return this.root;
        }

        public void setRoot(String root) {
            this.root = root;
        }

        public String[] getAllMonthYearKeys() {
            return this.keySet().toArray(new String[this.size()]);
        }

        public String[] getAllStrikeSymbols() {
            String[] allMonthYearKeys;
            ArrayList<String> symbols = new ArrayList<String>();
            for (String key : allMonthYearKeys = this.getAllMonthYearKeys()) {
                OptionMonthYear optionMonthYear = (OptionMonthYear)this.get(key);
                String[] strikes = optionMonthYear.getAllStrikeSymbols();
                symbols.addAll(Arrays.asList(strikes));
            }
            return symbols.toArray(new String[symbols.size()]);
        }

        public String[] getMonthYearStrikeSymbols(String monthYear) {
            String[] ret = new String[]{};
            OptionMonthYear optionMonthYear = (OptionMonthYear)this.get(monthYear);
            if (optionMonthYear != null) {
                ret = optionMonthYear.getAllStrikeSymbols();
            }
            return ret;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("Options: " + this.root + " totalMonthYears: " + this.size());
            int numStrikes = 0;
            String tmp = null;
            for (Map.Entry my : this.entrySet()) {
                numStrikes += ((OptionMonthYear)my.getValue()).getAllStrikeSymbols().length;
                tmp = tmp + (String)my.getKey() + "=" + ((OptionMonthYear)my.getValue()).getAllStrikeSymbols().length + ", ";
            }
            sb.append(" totalStrikes: " + numStrikes + "\n");
            sb.append(tmp);
            return sb.toString();
        }
    }

    static class FuturesRoot {
        private String root;
        private String root_crb;
        private String description;
        private String exchange;
        private FutureContract[] contracts;
        private FutureContract nearestContract;
        private List<String> contractSymbols = new ArrayList<String>();

        FuturesRoot() {
        }

        public String getRoot() {
            return this.root;
        }

        public String getSymbolByMonth(int month) {
            if (month >= this.contractSymbols.size() || month < 0) {
                StringBuilder sb = new StringBuilder("Invalid contract month: " + month + " root: " + this.root + " valid months: ");
                for (int i = 0; i < this.contractSymbols.size(); ++i) {
                    sb.append(i + "=" + this.contractSymbols.get(i) + ", ");
                }
                logger.error(sb.toString());
                return null;
            }
            return this.contractSymbols.get(month);
        }

        public void addContractSymbol(String s) {
            this.contractSymbols.add(s);
        }

        public String[] getContractSymbols() {
            return this.contractSymbols.toArray(new String[0]);
        }

        public void setNearestContract(FutureContract c) {
            this.nearestContract = c;
        }

        public FutureContract getNearestContract() {
            return this.nearestContract;
        }

        public void setRoot(String root) {
            this.root = root;
        }

        public FutureContract[] getContracts() {
            return this.contracts;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Futures: " + this.root + " desc: " + this.description);
            sb.append(" nearest: " + this.nearestContract);
            sb.append("\nsymbols: ");
            for (int i = 0; i < this.contractSymbols.size(); ++i) {
                sb.append(i + "=" + this.contractSymbols.get(i) + ", ");
            }
            return sb.toString();
        }
    }

    private class RefreshThread
    implements Runnable {
        private RefreshThread() {
        }

        @Override
        public void run() {
            logger.info("Running background symbol refresh..");
            for (String root : DefinitionServiceImpl.this.futureRoots.keySet()) {
                logger.info("Running symbol refresh for future root: " + root);
                DefinitionServiceImpl.this.buildFutureContractCache(root);
            }
            for (String root : DefinitionServiceImpl.this.optionsRoots.keySet()) {
                logger.info("Running symbol refresh for option root: " + root);
                DefinitionServiceImpl.this.buildOptionsContractCache(root);
            }
            Set usedExchangeCodes = DefinitionServiceImpl.this.exchangeSymbols.keySet();
            for (String exchange : usedExchangeCodes) {
                DefinitionServiceImpl.this.lookUpExchangeSymbols(exchange, true);
            }
        }
    }

    static class FutureContract {
        private String month;
        private String year;
        private boolean isnearest;
        private String symbol;

        FutureContract() {
        }

        public String getMonth() {
            return this.month;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public void setSymbol(String s) {
            this.symbol = s;
        }

        public void setMonth(String month) {
            this.month = month;
        }

        public String getYear() {
            return this.year;
        }

        public void setYear(String year) {
            this.year = year;
        }

        public boolean isIsnearest() {
            return this.isnearest;
        }

        public void setIsnearest(boolean isnearest) {
            this.isnearest = isnearest;
        }

        public String toString() {
            return this.symbol + " mon: " + this.month + " year: " + this.year + " nearest:" + this.isnearest;
        }
    }

    static class InstrumentDefinition {
        private String symbol_ddf;
        private String exchange;

        InstrumentDefinition() {
        }

        public String getSymbol_ddf() {
            return this.symbol_ddf;
        }

        public void setSymbol_ddf(String symbol_ddf) {
            this.symbol_ddf = symbol_ddf;
        }

        public String getExchange() {
            return this.exchange;
        }

        public void setExchange(String exchange) {
            this.exchange = exchange;
        }
    }

    static class OptionsStrike {
        private String strike;
        private String type;

        OptionsStrike() {
        }

        public String getStrike() {
            return this.strike;
        }

        public void setStrike(String strike) {
            this.strike = strike;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    static class OptionMonthYear {
        private String monthYear;
        private String expiration_date;
        private String underlying_future;
        private String days_to_expration;
        private String month;
        private String year;
        private Map<String, OptionsStrike> strikes;

        OptionMonthYear() {
        }

        public String[] getAllStrikeSymbols() {
            return this.strikes.keySet().toArray(new String[this.strikes.size()]);
        }

        public Map<String, OptionsStrike> getStrikes() {
            return this.strikes;
        }

        public String getExpiration_date() {
            return this.expiration_date;
        }

        public void setExpiration_date(String expiration_date) {
            this.expiration_date = expiration_date;
        }

        public String getUnderlying_future() {
            return this.underlying_future;
        }

        public void setUnderlying_future(String underlying_future) {
            this.underlying_future = underlying_future;
        }

        public String getDays_to_expration() {
            return this.days_to_expration;
        }

        public void setDays_to_expration(String days_to_expration) {
            this.days_to_expration = days_to_expration;
        }

        public String getMonth() {
            return this.month;
        }

        public void setMonth(String month) {
            this.month = month;
        }

        public String getYear() {
            return this.year;
        }

        public void setYear(String year) {
            this.year = year;
        }

        public String getMonthYear() {
            return this.monthYear;
        }

        public void setMonthYear(String monthYear) {
            this.monthYear = monthYear;
        }
    }
}

