/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.net;

import com.ddfplus.net.IoChannelListenUDP;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XQueueUDP
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(XQueueUDP.class);
    private volatile int _maxSize = 0;
    private final BlockingQueue<byte[]> messageQueue;
    private final IoChannelListenUDP reader;

    public XQueueUDP(IoChannelListenUDP reader) {
        super("XQueue for " + reader.getConnection().getId());
        this.reader = reader;
        this.messageQueue = new LinkedBlockingQueue<byte[]>();
        this.start();
    }

    public void add(byte[] message) {
        try {
            this.messageQueue.put(message);
            this._maxSize = Math.max(this._maxSize, this.messageQueue.size());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    public int getMaxSize() {
        return this._maxSize;
    }

    public int getSize() {
        return this.messageQueue.size();
    }

    @Override
    public void run() {
        int priority = 10;
        this.setPriority(10);
        String name = this.getName();
        log.info("name={} priority={}", (Object)name, (Object)10);
        while (true) {
            try {
                while (true) {
                    byte[] buffer = this.messageQueue.take();
                    this.reader.distributeMessage(buffer);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

