/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.net;

import com.ddfplus.net.SymbolShortCuts;
import com.ddfplus.service.definition.DefinitionService;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymbolShortCutsImpl
implements SymbolShortCuts {
    private static final char INDEX = '$';
    private static final String ALL_FUTURES = "^F";
    private static final String ALL_OPTIONS = "^O";
    private static final String ALL_OPTIONS_MONTH_YEAR = "^OM";
    private static final String FUTURE_MONTH_SHORTCUT = "*";
    private static final String CTRL = "^";
    private static final Pattern DDF_SYMBOL_PATTERN = Pattern.compile("(\\D+)(\\D)(\\d+)");
    private static final Logger log = LoggerFactory.getLogger((String)"SymbolShortCuts");
    private DefinitionService definitionService;
    private Map<Character, Character> farOutMonths = new HashMap<Character, Character>();

    public SymbolShortCutsImpl(DefinitionService definitionService) {
        this.definitionService = definitionService;
        this.farOutMonths.put(Character.valueOf('F'), Character.valueOf('A'));
        this.farOutMonths.put(Character.valueOf('G'), Character.valueOf('B'));
        this.farOutMonths.put(Character.valueOf('H'), Character.valueOf('C'));
        this.farOutMonths.put(Character.valueOf('J'), Character.valueOf('D'));
        this.farOutMonths.put(Character.valueOf('K'), Character.valueOf('E'));
        this.farOutMonths.put(Character.valueOf('M'), Character.valueOf('I'));
        this.farOutMonths.put(Character.valueOf('N'), Character.valueOf('L'));
        this.farOutMonths.put(Character.valueOf('Q'), Character.valueOf('O'));
        this.farOutMonths.put(Character.valueOf('U'), Character.valueOf('P'));
        this.farOutMonths.put(Character.valueOf('V'), Character.valueOf('R'));
        this.farOutMonths.put(Character.valueOf('X'), Character.valueOf('S'));
        this.farOutMonths.put(Character.valueOf('Z'), Character.valueOf('T'));
    }

    @Override
    public String[] resolveShortCutSymbols(String symbol) {
        String[] noSymbol = new String[]{};
        if (symbol == null || symbol.isEmpty()) {
            return noSymbol;
        }
        if (symbol.charAt(0) == '$') {
            return new String[]{symbol};
        }
        String root = null;
        if (symbol.endsWith(ALL_FUTURES)) {
            root = symbol.substring(0, symbol.length() - ALL_FUTURES.length());
            String[] symbols = this.definitionService.getAllFutureSymbols(root);
            if (symbols.length > 0) {
                return symbols;
            }
            return noSymbol;
        }
        int i = symbol.indexOf(FUTURE_MONTH_SHORTCUT);
        if (i > 0) {
            String s = this.getMonthSymbol(symbol, i);
            if (s != null) {
                return new String[]{s};
            }
            return noSymbol;
        }
        if (symbol.endsWith(ALL_OPTIONS)) {
            root = symbol.substring(0, symbol.length() - ALL_OPTIONS.length());
            String[] symbols = this.definitionService.getAllOptionsSymbols(root);
            if (symbols.length > 0) {
                return symbols;
            }
            return noSymbol;
        }
        if (symbol.endsWith(ALL_OPTIONS_MONTH_YEAR)) {
            String[] symbols;
            int last;
            String monthYear = null;
            int first = symbol.indexOf(CTRL);
            if (first > 0) {
                root = symbol.substring(0, first);
            }
            if ((last = symbol.lastIndexOf(CTRL)) > 0) {
                monthYear = symbol.substring(first + 1, last);
            }
            if (root != null && monthYear != null && (symbols = this.definitionService.getAllOptionsMonthYearSymbols(root, monthYear)).length > 0) {
                return symbols;
            }
            return noSymbol;
        }
        String ddfFeedSymbol = this.convertToDdfFeedSymbol(symbol);
        if (ddfFeedSymbol != null) {
            return new String[]{ddfFeedSymbol};
        }
        return new String[]{symbol};
    }

    String convertToDdfFeedSymbol(String symbol) {
        Matcher m = DDF_SYMBOL_PATTERN.matcher(symbol);
        if (m.matches()) {
            String s = m.group(1);
            char month = m.group(2).charAt(0);
            String yearString = m.group(3);
            int year = Integer.parseInt(yearString);
            int rawYear = year % 2000;
            if (s.equals("NG") && rawYear >= 10) {
                Character newMonth = this.farOutMonths.get(Character.valueOf(month));
                if (newMonth != null) {
                    month = newMonth.charValue();
                } else {
                    log.error("Lookup for far out month for symbol: " + symbol + " failed.");
                }
            }
            String ddfSymbol = s + month + yearString.charAt(yearString.length() - 1);
            return ddfSymbol;
        }
        return symbol;
    }

    String getMonthSymbol(String symbol, int i) {
        String ret = null;
        try {
            int month = Integer.parseInt(symbol.substring(i + 1));
            String root = symbol.substring(0, i);
            ret = this.definitionService.getFuturesMonthSymbol(root, month);
        }
        catch (NumberFormatException nfe) {
            log.error("Invalid month identifier on symbol: " + symbol + " streaming not active.");
        }
        return ret;
    }

    void setDefinitionService(DefinitionService definitionService) {
        this.definitionService = definitionService;
    }
}

