/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.net;

import com.ddfplus.api.ConnectionEventType;
import com.ddfplus.enums.ConnectionType;
import com.ddfplus.net.Connection;
import com.ddfplus.net.IoChannel;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.glassfish.tyrus.client.ClientManager;
import org.glassfish.tyrus.container.jdk.client.JdkClientContainer;

class IoChannelWSS
extends IoChannel {
    private static int READ_BUF_SIZE = 2000000;
    private static final String WS_PREFIX = "ws://";
    private static final String WSS_PREFIX = "wss://";
    private static final String WSS_POSTFIX = "/jerq";
    private AtomicBoolean running = new AtomicBoolean(true);
    private CountDownLatch connectionLatch;
    private CountDownLatch sessionFinishedLatch;
    private JerqWssEndPoint endpoint;
    private URI uri;
    private ClientManager clientManager;
    private ClientEndpointConfig clientEndpointConfig;
    private WssMessageTextStreamHandler messageHandler;
    private boolean reconnection;

    public IoChannelWSS(Connection connection) {
        super(connection);
        if (this.symbolProvider == null) {
            throw new IllegalArgumentException("Symbol Provider cannot be null");
        }
        String addr = null;
        addr = connection.getConnectionType() == ConnectionType.WS ? WS_PREFIX + connection.primaryServer.getHostName() + ":" + connection.getPort() + WSS_POSTFIX : WSS_PREFIX + connection.primaryServer.getHostName() + WSS_POSTFIX;
        try {
            this.uri = new URI(addr);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not create Web Socket URI: " + e.getMessage());
        }
    }

    @Override
    public void run() {
        this.log.info("Started Jerq Web Socket Client to: " + this.connection.primaryServer);
        while (this.running.get()) {
            try {
                this.sessionFinishedLatch = new CountDownLatch(1);
                boolean ret = this.connectToServer();
                if (!ret || this.connState == IoChannel.ConnectionState.NotConnected) {
                    this.log.warn("WebSocket connection issue, retrying in: 3 seconds.");
                    this.sleep(3000);
                    continue;
                }
                this.sessionFinishedLatch.await();
                this.log.info("Web socket session has closed.");
                if (!this.reconnection) continue;
                this.log.warn("Awaiting 3 seconds before reconnection.");
                this.sleep(3000);
            }
            catch (Exception e) {
                this.log.error("WebSocket error runState: " + this.running.get() + " error: ", (Throwable)e);
            }
        }
        if (this.clientManager != null) {
            this.clientManager.shutdown();
            this.clientManager = null;
        }
        this.log.info("Stopped Jerq Web Socket Client to " + this.connection.primaryServer);
    }

    @Override
    public void disconnectAndShutdown() {
        if (this.clientManager != null) {
            this.clientManager.shutdown();
            this.clientManager = null;
        }
        this.running.set(false);
        this.sessionFinishedLatch.countDown();
    }

    @Override
    protected void sendCommand(String cmd) {
        this.endpoint.sendCmd(cmd);
    }

    private boolean connectToServer() throws URISyntaxException, DeploymentException, IOException, InterruptedException {
        this.clientManager = ClientManager.createClient((String)JdkClientContainer.class.getName());
        int idleTimeOutMs = this.createReadTimeoutMs();
        this.clientManager.setDefaultMaxSessionIdleTimeout((long)idleTimeOutMs);
        if (this.log.isDebugEnabled()) {
            this.clientManager.getProperties().put("org.glassfish.tyrus.client.http.logUpgrade", true);
        }
        this.clientEndpointConfig = ClientEndpointConfig.Builder.create().build();
        this.messageHandler = new WssMessageTextStreamHandler();
        this.endpoint = new JerqWssEndPoint(this.messageHandler);
        this.connectionLatch = new CountDownLatch(1);
        this.log.info("Starting connection to: " + this.uri);
        try {
            Session session = this.clientManager.connectToServer((Endpoint)this.endpoint, this.clientEndpointConfig, this.uri);
            this.log.info("Endpoint: sendTimeout: " + this.clientManager.getDefaultAsyncSendTimeout() + " binaryBufSize: " + this.clientManager.getDefaultMaxBinaryMessageBufferSize() + " sessionIdleTimeOutMs: " + this.clientManager.getDefaultMaxSessionIdleTimeout() + " textBufSize: " + this.clientManager.getDefaultMaxTextMessageBufferSize());
        }
        catch (DeploymentException e) {
            this.log.error("Deployment Exception: Could not connect to: " + this.uri + " reason: " + e.getMessage());
            return false;
        }
        catch (Exception e) {
            this.log.error("Exception: Could not connect to: " + this.uri + " reason: " + e.getMessage());
            return false;
        }
        boolean ret = this.connectionLatch.await(60L, TimeUnit.SECONDS);
        return ret;
    }

    private void closeSession() {
        this.clientManager.shutdown();
        this.connState = IoChannel.ConnectionState.NotConnected;
        if (this.running.get()) {
            this.reconnection = true;
        }
        this.sessionFinishedLatch.countDown();
    }

    static /* synthetic */ int access$300() {
        return READ_BUF_SIZE;
    }

    private class JerqWssEndPoint
    extends Endpoint {
        private WssMessageTextStreamHandler handler;
        private Session session;

        public JerqWssEndPoint(WssMessageTextStreamHandler messageHandler) {
            this.handler = messageHandler;
        }

        public void onOpen(Session session, EndpointConfig config) {
            this.session = session;
            IoChannelWSS.this.log.info("Endpoint connected to: " + IoChannelWSS.this.uri);
            session.addMessageHandler((MessageHandler)this.handler);
            IoChannelWSS.this.connState = IoChannel.ConnectionState.Connecting;
        }

        public void onClose(Session session, CloseReason closeReason) {
            IoChannelWSS.this.log.warn("Endpoint close, reason: " + closeReason);
            IoChannelWSS.this.closeSession();
        }

        public void onError(Session session, Throwable thr) {
            IoChannelWSS.this.log.error("Endpoint error: " + session, thr);
            IoChannelWSS.this.closeSession();
        }

        public void sendCmd(String cmd) {
            if (this.session != null) {
                try {
                    this.session.getBasicRemote().sendText(cmd);
                }
                catch (IOException e) {
                    IoChannelWSS.this.log.error("Cannot send command: " + cmd, (Throwable)e);
                }
            } else {
                IoChannelWSS.this.log.warn("Cannot send command, session is closed: " + cmd);
            }
        }
    }

    private class WssMessageTextStreamHandler
    implements MessageHandler.Whole<Reader> {
        private char[] buf = new char[IoChannelWSS.access$300()];
        private StringBuilder bufPartial = new StringBuilder(100);
        private int partialCount;

        private WssMessageTextStreamHandler() {
        }

        public void onMessage(Reader reader) {
            if (IoChannelWSS.this.log.isDebugEnabled()) {
                IoChannelWSS.this.log.debug("+++++++++++++++++++ onMessage ++++++++++++++++++++++++++++++++++++++++");
            }
            int index = -1;
            String packet = null;
            try {
                while (reader.ready()) {
                    boolean haveFullPacket;
                    int c = reader.read();
                    ++index;
                    if (c == -1) {
                        if (index > 0) {
                            packet = new String(this.buf, 0, index);
                            if (IoChannelWSS.this.log.isDebugEnabled()) {
                                IoChannelWSS.this.log.debug("<BUFEND " + packet);
                            }
                            if (haveFullPacket = this.checkFraming(packet)) {
                                this.handlePacket(packet);
                            } else {
                                this.handePartialPacket(packet);
                            }
                        }
                        break;
                    }
                    if (c == 10) {
                        packet = new String(this.buf, 0, index);
                        if (IoChannelWSS.this.log.isDebugEnabled()) {
                            IoChannelWSS.this.log.debug("<BUF " + packet);
                        }
                        if (haveFullPacket = this.checkFraming(packet)) {
                            this.handlePacket(packet);
                        } else {
                            this.handePartialPacket(packet);
                        }
                        index = -1;
                        continue;
                    }
                    this.buf[index] = (char)c;
                }
            }
            catch (IOException e1) {
                IoChannelWSS.this.log.error("WSS read error: ", (Throwable)e1);
            }
            if (IoChannelWSS.this.log.isDebugEnabled()) {
                IoChannelWSS.this.log.debug("++++++ Leaving onMessage ++++++++++++++++++++++++++++++++++++++++");
            }
        }

        private void handePartialPacket(String packet) {
            if (IoChannelWSS.this.log.isDebugEnabled()) {
                IoChannelWSS.this.log.debug("<PARTIAL buf: " + this.bufPartial.toString() + " pkt: " + packet);
            }
            this.bufPartial.append(packet);
            ++this.partialCount;
            if (this.partialCount == 2) {
                if (this.checkFraming(this.bufPartial.toString())) {
                    if (IoChannelWSS.this.log.isDebugEnabled()) {
                        IoChannelWSS.this.log.debug("<PARTIAL DONE" + this.bufPartial.toString());
                    }
                    this.handlePacket(this.bufPartial.toString());
                }
                this.partialCount = 0;
                this.bufPartial.setLength(0);
            }
        }

        private int hasSOH(char[] buf) {
            for (int i = 0; i < buf.length; ++i) {
                if (buf[i] != '\u0001') continue;
                return i;
            }
            return -1;
        }

        private int hasEtx(char[] buf) {
            for (int i = 0; i < buf.length; ++i) {
                if (buf[i] != '\u0003') continue;
                return i;
            }
            return -1;
        }

        private boolean checkFraming(String packet) {
            if (IoChannelWSS.this.connState != IoChannel.ConnectionState.LoggedIn) {
                return true;
            }
            if (this.buf[0] == '-' || this.buf[0] == '+') {
                return true;
            }
            char[] data = packet.toCharArray();
            boolean startRefresh = packet.contains("<QUOTE ");
            boolean endEndRefresh = packet.contains("</QUOTE>");
            if (startRefresh || endEndRefresh) {
                return startRefresh && endEndRefresh;
            }
            int soh = this.hasSOH(data);
            int etx = this.hasEtx(data);
            if (soh < 0 || etx < 0) {
                return false;
            }
            return soh <= etx;
        }

        private void handlePacket(String msgString) {
            try {
                if (msgString.length() == 0) {
                    return;
                }
                if (IoChannelWSS.this.log.isDebugEnabled()) {
                    IoChannelWSS.this.log.debug("handlePacket: " + msgString);
                }
                if (IoChannelWSS.this.connState == IoChannel.ConnectionState.Connecting) {
                    this.handleConnectionHeader(msgString);
                } else if (IoChannelWSS.this.connState == IoChannel.ConnectionState.Connected) {
                    this.handleLogon(msgString);
                } else if (IoChannelWSS.this.connState == IoChannel.ConnectionState.LoggedIn) {
                    if (msgString.startsWith("+")) {
                        IoChannelWSS.this.log.info("SERVER INFO: " + msgString);
                    } else if (msgString.startsWith("-")) {
                        IoChannelWSS.this.log.warn("SERVER ERROR: " + msgString);
                    } else if (msgString.startsWith("+ STOPPED DATA STREAM")) {
                        IoChannelWSS.this.log.error("SERVER ERROR " + msgString);
                        IoChannelWSS.this.closeSession();
                    } else {
                        byte[] bytes = msgString.getBytes();
                        if (bytes[0] == 37) {
                            IoChannelWSS.this.connection.handleMessage(msgString);
                        } else {
                            if (msgString.length() < 2) {
                                return;
                            }
                            IoChannelWSS.this.connection.handleMessage(msgString);
                        }
                    }
                }
            }
            catch (Exception e) {
                IoChannelWSS.this.log.error("Could not process message: " + msgString + " error: ", (Throwable)e);
            }
        }

        private void handleConnectionHeader(String message) {
            if (message.endsWith("+++")) {
                IoChannelWSS.this.connState = IoChannel.ConnectionState.Connected;
                IoChannelWSS.this.connection.handleEvent(IoChannelWSS.this.makeConnectionEvent(ConnectionEventType.CONNECTED, IoChannelWSS.this.reconnection));
                String command = "LOGIN " + IoChannelWSS.this.connection.username + ":" + IoChannelWSS.this.connection.password + " VERSION=" + IoChannelWSS.this.connection.getVersion();
                IoChannelWSS.this.enqueueCommand(command);
            }
        }

        private void handleLogon(String message) {
            if (message.startsWith("-")) {
                IoChannelWSS.this.connState = IoChannel.ConnectionState.NotConnected;
                IoChannelWSS.this.log.error("Jerq WS Client, the server reported an invalid login attempt: " + message);
                IoChannelWSS.this.connection.handleEvent(IoChannelWSS.this.makeConnectionEvent(ConnectionEventType.LOGIN_FAILED, IoChannelWSS.this.reconnection));
            } else if (message.startsWith("+ Successful login")) {
                IoChannelWSS.this.log.info("Sucessful login for: " + IoChannelWSS.this.connection.username);
                IoChannelWSS.this.connState = IoChannel.ConnectionState.LoggedIn;
                IoChannelWSS.this.connection.handleEvent(IoChannelWSS.this.makeConnectionEvent(ConnectionEventType.LOGIN_SUCCESS, IoChannelWSS.this.reconnection));
                if (IoChannelWSS.this.reconnection) {
                    IoChannelWSS.this.resendSubscriptionsOnReconnection();
                    IoChannelWSS.this.reconnection = false;
                }
            }
            IoChannelWSS.this.connectionLatch.countDown();
        }
    }
}

