/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.net;

import com.ddfplus.api.ConnectionEvent;
import com.ddfplus.api.ConnectionEventType;
import com.ddfplus.net.Connection;
import com.ddfplus.net.IoChannel;
import com.ddfplus.net.SymbolProvider;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.StringTokenizer;

class IoChannelUDP
extends IoChannel {
    private volatile boolean bDoStop = false;
    volatile DatagramSocket socket = null;

    public IoChannelUDP(Connection connection, SymbolProvider symbolProvider) {
        super(connection);
        if (symbolProvider == null) {
            throw new IllegalArgumentException("Symbol Provider cannot be null");
        }
        this.symbolProvider = symbolProvider;
    }

    @Override
    public void run() {
        this.log.info("[INF] Started JerqUDPListener (UDP Streaming Mode) to " + this.connection.primaryServer + ":" + this.connection.port + ".");
        while (!this.bDoStop) {
            try {
                String symbols;
                this.socket = new DatagramSocket();
                this.socket.setSoTimeout(this.createReadTimeoutMs());
                String header = this.connection.username + ":" + this.connection.password + ":";
                if (this.connection.version > 1) {
                    header = header + this.connection.version + ":";
                }
                if ((symbols = this.symbolProvider.getSymbols()) == null || symbols.length() < 1) {
                    return;
                }
                if (symbols.indexOf(";") > 0) {
                    symbols = symbols.replace(';', ',');
                    header = header + "X";
                } else {
                    header = header + "G";
                }
                String cmd = header + symbols;
                byte[] ba = cmd.getBytes();
                this.log.info("Sending UDP Command: " + cmd);
                DatagramPacket out_packet = new DatagramPacket(ba, ba.length, this.connection.primaryServer, this.connection.port);
                this.socket.send(out_packet);
                this.isRunning = true;
                boolean bDidEvent = false;
                while (this.isRunning) {
                    try {
                        DatagramPacket in_packet = new DatagramPacket(new byte[1460], 1460);
                        this.socket.receive(in_packet);
                        StringTokenizer st = new StringTokenizer(new String(in_packet.getData(), 0, in_packet.getLength()), "\n");
                        while (st.hasMoreTokens()) {
                            this.connection.handleMessage(st.nextToken());
                        }
                        if (bDidEvent) continue;
                        this.connection.handleEvent(new ConnectionEvent(ConnectionEventType.CONNECTED));
                        bDidEvent = true;
                    }
                    catch (SocketException se) {
                        this.log.error("JerqUDPListener.run(recv): " + se);
                        this.isRunning = false;
                    }
                    catch (IOException ioe) {
                        this.log.error("JerqUDPListener.run(recv io): " + ioe);
                        this.isRunning = false;
                    }
                }
            }
            catch (IOException ioe) {
                this.log.error("JerqUDPListener.run(startup): " + ioe);
            }
        }
        this.connection.handleEvent(new ConnectionEvent(ConnectionEventType.DISCONNECTED));
        this.log.info("[INF] Stopped JerqUDPListener (UDP Streaming Mode) to " + this.connection.primaryServer + ".");
    }

    @Override
    public void disconnectAndShutdown() {
        try {
            this.bDoStop = true;
            if (this.socket != null) {
                String cmd = this.connection.username + ":" + this.connection.password + ":G";
                byte[] ba = cmd.getBytes();
                DatagramPacket out_packet = new DatagramPacket(ba, ba.length, this.connection.primaryServer, this.connection.port);
                this.socket.send(out_packet);
                this.socket.close();
            }
        }
        catch (Exception e) {
            this.log.error("JerqUDPListener.disconnect(): " + e);
        }
    }

    @Override
    protected void sendCommand(String cmd) {
    }
}

