/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.net;

import com.ddfplus.api.ConnectionEventType;
import com.ddfplus.net.Connection;
import com.ddfplus.net.IoChannel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

class IoChannelTCP
extends IoChannel {
    private static int _nextId = 1;
    private int _id = 0;
    private Socket socket = null;
    private BufferedReader in = null;
    private PrintWriter out = null;
    private AtomicBoolean bDoStop = new AtomicBoolean(false);
    private boolean reconnection;
    private InetAddress currentServerAddress;
    private InetAddress backupServerAddress;
    private String logPrefix;
    private int socketReadTimeOutMs;

    public IoChannelTCP(Connection connection) {
        super(connection);
        this._id = _nextId++;
        this.logPrefix = "[INF " + this._id + "] ";
    }

    @Override
    public void run() {
        this.currentServerAddress = this.connection.primaryServer;
        this.backupServerAddress = this.connection.secondaryServer;
        this.log.info("[INF " + this._id + "] Started JerqTCPListener (TCP Streaming mode) to " + this.currentServerAddress);
        while (!this.bDoStop.get()) {
            if (this.connectToServer()) {
                this.isRunning = true;
                try {
                    while (this.isRunning) {
                        String line = null;
                        try {
                            line = this.in.readLine();
                        }
                        catch (SocketTimeoutException ste) {
                            this.log.info("[_id] read timeout, will reconnect.");
                            this.isRunning = false;
                        }
                        if (line == null) {
                            this.log.info("Received end of stream, disconnected from: " + this.currentServerAddress);
                            this.isRunning = false;
                            continue;
                        }
                        if (line.trim().isEmpty()) continue;
                        if (line.startsWith("+ STOPPED DATA STREAM")) {
                            this.log.warn("Server disconnected, connection will be re-established.");
                            this.isRunning = false;
                            continue;
                        }
                        if (line.startsWith("+")) {
                            this.log.info("Server info: " + line);
                            continue;
                        }
                        this.connection.handleMessage(line);
                    }
                }
                catch (SocketException se) {
                    this.log.error("[ERR " + this._id + "] JerqTCPListener.run(): communications error - " + se);
                }
                catch (Exception e) {
                    this.log.error("[ERR " + this._id + "] JerqTCPListener.run(): error streaming quotes - " + e);
                }
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException io) {
                        this.log.error(this.logPrefix + " Socket close issue: " + io);
                    }
                }
                this.socket = null;
            }
            this.connection.handleEvent(this.makeConnectionEvent(ConnectionEventType.DISCONNECTED, this.reconnection));
            this.log.warn("[INF " + this._id + "] Disconnected from " + this.currentServerAddress + ":" + this.connection.port);
            if (this.bDoStop.get()) continue;
            try {
                this.reconnection = true;
                int reconnectionMs = 3000 + (int)(Math.random() * 10.0) * 500;
                this.log.info("Will attempt reconnection in " + reconnectionMs + " ms");
                Thread.sleep(reconnectionMs);
            }
            catch (Exception e) {
                this.log.error(this.logPrefix + " reconnection issue: " + e.getMessage());
            }
        }
        this.log.info("[INF " + this._id + "] Stopped JerqTCPListener (TCP Streaming mode) to " + this.currentServerAddress);
    }

    @Override
    protected void sendCommand(String cmd) {
        if (this.out != null) {
            this.out.print(cmd + "\n");
            this.out.flush();
        }
    }

    @Override
    public void disconnectAndShutdown() {
        this.bDoStop.set(true);
        this.isRunning = false;
        this.disconnectFromServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectToServer() {
        boolean isSuccess = false;
        Connection connection = this.connection;
        synchronized (connection) {
            if (this.socket != null) {
                this.log.warn("connectToServer called twice, returning.");
                return false;
            }
            try {
                if (this.reconnection && this.backupServerAddress != null) {
                    InetAddress temp = this.currentServerAddress;
                    this.currentServerAddress = this.backupServerAddress;
                    this.backupServerAddress = temp;
                }
                this.log.warn("[INF " + this._id + "] Connecting via TCP to " + this.currentServerAddress + ":" + this.connection.port);
                this.socket = new Socket(this.currentServerAddress, this.connection.port);
                this.socketReadTimeOutMs = this.createReadTimeoutMs();
                this.socket.setSoTimeout(this.socketReadTimeOutMs);
                this.socket.setTcpNoDelay(true);
                this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                this.log.info("[INF " + this._id + " tid: " + Thread.currentThread().getId() + "] Connected to " + this.currentServerAddress + ":" + this.connection.port + " localAddr: " + this.socket.getLocalAddress() + ":" + this.socket.getLocalPort() + " readTimeOutMs: " + this.socketReadTimeOutMs);
                this.connState = IoChannel.ConnectionState.Connected;
                this.connection.handleEvent(this.makeConnectionEvent(ConnectionEventType.CONNECTED, this.reconnection));
                boolean isDone = false;
                while (!isDone) {
                    String line = this.in.readLine();
                    if (line == null) {
                        isDone = true;
                        continue;
                    }
                    if (!line.startsWith("+++")) continue;
                    isDone = true;
                }
                this.out = new PrintWriter(this.socket.getOutputStream());
                String command = "LOGIN " + this.connection.username + ":" + this.connection.password + " VERSION=" + this.connection.getVersion();
                this.enqueueCommand(command);
                String line = this.in.readLine();
                this.log.info("line={}", (Object)line);
                if (line == null || line.startsWith("-")) {
                    this.connection.handleEvent(this.makeConnectionEvent(ConnectionEventType.LOGIN_FAILED, this.reconnection));
                    this.log.error("JerqTCPListener[" + this._id + "].run(): The server reported an invalid login attempt (" + command + "): " + line);
                } else {
                    this.connState = IoChannel.ConnectionState.LoggedIn;
                    this.connection.handleEvent(this.makeConnectionEvent(ConnectionEventType.LOGIN_SUCCESS, this.reconnection));
                    isSuccess = true;
                    if (this.reconnection) {
                        this.resendSubscriptionsOnReconnection();
                    }
                }
            }
            catch (IOException ioe) {
                this.log.error("JerqTCPListener[" + this._id + "].run(): There was an error during connection: " + ioe);
                this.connection.handleEvent(this.makeConnectionEvent(ConnectionEventType.CONNECTION_FAILED, this.reconnection));
            }
            catch (Exception e) {
                this.log.error("JerqTCPListener[" + this._id + "].run(): There was an uncaught exception during connection: ", (Throwable)e);
                this.connection.handleEvent(this.makeConnectionEvent(ConnectionEventType.CONNECTION_FAILED, this.reconnection));
            }
            if (!isSuccess) {
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.in = null;
                if (this.out != null) {
                    try {
                        this.out.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.out = null;
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.socket = null;
                this.connState = IoChannel.ConnectionState.NotConnected;
            }
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectFromServer() {
        Connection connection = this.connection;
        synchronized (connection) {
            this.log.warn("[INF " + this._id + "] JerqTCPListener Closing");
            try {
                this.sendCommand("LOGOFF");
            }
            catch (Exception e) {
                this.log.error("JerqTCPListener[" + this._id + "].disconnectFromServer(): " + e);
            }
            this.stopCommandThread();
            this.connection.handleEvent(this.makeConnectionEvent(ConnectionEventType.DISCONNECTED, this.reconnection));
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.socket = null;
            this.log.info("[INF " + this._id + "] JerqTCPListener Closed.");
        }
    }
}

