/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.net;

import com.ddfplus.net.Connection;
import com.ddfplus.net.IoChannel;
import com.ddfplus.net.XQueueUDP;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IoChannelListenUDP
extends IoChannel {
    static final Logger log = LoggerFactory.getLogger(IoChannelListenUDP.class);
    private final XQueueUDP queueThread = new XQueueUDP(this);

    public IoChannelListenUDP(Connection connection) {
        super(connection);
    }

    @Override
    public int getMaxQueueSize() {
        return this.queueThread.getMaxSize();
    }

    @Override
    public int getQueueSize() {
        return this.queueThread.getSize();
    }

    @Override
    public void run() {
        byte[] array = new byte[2048];
        DatagramPacket packet = new DatagramPacket(array, 2048);
        DatagramSocket socket = null;
        while (true) {
            try {
                socket = this.makeSocket();
                log.info("made socket; " + this.connection.primaryServer + ":" + this.connection.port);
                while (true) {
                    packet.setData(array);
                    socket.receive(packet);
                    byte[] ba = new byte[packet.getLength()];
                    System.arraycopy(array, 0, ba, 0, ba.length);
                    this.queueThread.add(ba);
                }
            }
            catch (Exception e) {
                log.error("receive failed; " + this.connection.primaryServer + ":" + this.connection.port);
                log.error("", (Throwable)e);
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (Exception e2) {
                    log.error("close failed", (Throwable)e2);
                }
                try {
                    this.sleep(1000);
                    continue;
                }
                catch (Exception e3) {
                    log.error("unexpected", (Throwable)e3);
                    continue;
                }
            }
            break;
        }
    }

    @Override
    public void disconnectAndShutdown() {
    }

    @Override
    protected void sendCommand(String cmd) {
    }

    private DatagramSocket makeSocket() throws Exception {
        DatagramSocket socket;
        if (this.connection.primaryServer.isMulticastAddress()) {
            socket = new MulticastSocket(this.connection.port);
            MulticastSocket socketMC = (MulticastSocket)socket;
            if (this.connection.intf != null) {
                socketMC.setInterface(this.connection.intf);
            }
            socketMC.joinGroup(this.connection.primaryServer);
        } else {
            socket = new DatagramSocket(null);
            socket.setReuseAddress(true);
            InetSocketAddress socketAddress = new InetSocketAddress(this.connection.primaryServer, this.connection.port);
            socket.bind(socketAddress);
        }
        socket.setReceiveBufferSize(0x200000);
        log.info("DDF UDP Listener getReceiveBufferSize(): " + socket.getReceiveBufferSize());
        return socket;
    }
}

