/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.net;

import com.ddfplus.net.Connection;
import com.ddfplus.net.IoChannel;
import com.ddfplus.net.XQueueTCP;
import java.io.BufferedInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IoChannelListenTCP
extends IoChannel {
    private static final int SO_BUF_SIZE = 0x800000;
    static final int CLIENT_TIMEOUT = 20000;
    static final int PACKET_BUFFER = 65536;
    static final int TIME_STAMP_SIZE = 9;
    static final int EOF = -1;
    private static final Logger log = LoggerFactory.getLogger(IoChannelListenTCP.class);
    private final XQueueTCP queueThread = new XQueueTCP(this);

    public IoChannelListenTCP(Connection connection) {
        super(connection);
    }

    @Override
    public int getMaxQueueSize() {
        return this.queueThread.getMaxSize();
    }

    @Override
    public int getQueueSize() {
        return this.queueThread.getSize();
    }

    static void delay(long millis) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            log.debug("terminated");
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.runCore();
                }
            }
            catch (Throwable e) {
                log.error("listener run core failed", e);
                IoChannelListenTCP.delay(1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCore() throws Exception {
        log.info("listener start; local=" + this.connection.primaryServer + ":" + this.connection.port);
        ServerSocket server = new ServerSocket(this.connection.port, 0, this.connection.primaryServer);
        Socket client = null;
        try {
            client = server.accept();
            log.info("listener accept; remote=" + client.getInetAddress() + ":" + client.getPort());
            client.setSoTimeout(20000);
            log.info("listener inactivity timeout : {}", (Object)20000);
            int request = 0x800000;
            client.setReceiveBufferSize(0x800000);
            int actual = client.getReceiveBufferSize();
            if (actual >= 0x800000) {
                log.info("listener allocated receive buffer : {}", (Object)actual);
            } else {
                log.error("listener failed to allocate buffer; request: {}  actual:{} ;", (Object)0x800000, (Object)actual);
            }
            BufferedInputStream input = new BufferedInputStream(client.getInputStream());
            Machine machine = new Machine(input, this.connection);
            log.info("MACHINE INIT");
            machine.run();
            log.info("MACHINE DONE");
            log.info("listener finished; remote=" + client.getInetAddress() + ":" + client.getPort());
        }
        catch (Throwable e) {
            log.error("listener client session failed", e);
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (Exception e) {
                    log.error("unexpected", (Throwable)e);
                }
            }
        }
        if (server != null) {
            try {
                server.close();
            }
            catch (Exception e) {
                log.error("unexpected", (Throwable)e);
            }
        }
    }

    @Override
    public void disconnectAndShutdown() {
        log.info("listener disconnect");
    }

    @Override
    protected void sendCommand(String cmd) {
    }

    private class Machine {
        private final ByteBuffer buffer = ByteBuffer.allocate(65536);
        private final byte[] array = this.buffer.array();
        private final BufferedInputStream input;
        private final Connection connector;
        private int ender;

        Machine(BufferedInputStream input, Connection connector) {
            this.input = input;
            this.connector = connector;
        }

        void fire() {
            boolean start = false;
            int finish = this.buffer.position();
            int length = finish - 0;
            byte[] message = new byte[length];
            System.arraycopy(this.array, 0, message, 0, length);
            IoChannelListenTCP.this.queueThread.add(message);
        }

        void run() throws Exception {
            State state = State.S0_INIT;
            block16: while (true) {
                int result;
                if ((result = this.input.read()) == -1) break;
                byte alpha = (byte)result;
                switch (state) {
                    case S0_INIT: {
                        switch (alpha) {
                            case 1: {
                                this.buffer.clear();
                                this.buffer.put(alpha);
                                state = State.S1_DDF_SOH;
                                continue block16;
                            }
                        }
                        continue block16;
                    }
                    case S1_DDF_SOH: {
                        switch (alpha) {
                            case 3: {
                                state = State.S2_DDF_ETX;
                                this.buffer.put(alpha);
                                continue block16;
                            }
                        }
                        this.buffer.put(alpha);
                        continue block16;
                    }
                    case S2_DDF_ETX: {
                        switch (alpha) {
                            case 1: {
                                this.fire();
                                this.buffer.clear();
                                this.buffer.put(alpha);
                                state = State.S1_DDF_SOH;
                                continue block16;
                            }
                            case 20: {
                                this.buffer.put(alpha);
                                this.ender = 1;
                                state = State.S3_DDF_DC4;
                                continue block16;
                            }
                        }
                        log.error("machine reset: wrong alpha : {}", (Object)alpha);
                        state = State.S0_INIT;
                        continue block16;
                    }
                    case S3_DDF_DC4: {
                        this.buffer.put(alpha);
                        ++this.ender;
                        if (this.ender != 9) continue block16;
                        this.fire();
                        state = State.S0_INIT;
                        continue block16;
                    }
                }
                log.error("machine reset: wrong state : {}", (Object)state);
                state = State.S0_INIT;
            }
            log.warn("received end of stream; machine will exit now");
        }
    }

    private static enum State {
        S0_INIT,
        S1_DDF_SOH,
        S2_DDF_ETX,
        S3_DDF_DC4,
        S4_ERROR;

    }
}

