/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.net;

import com.ddfplus.api.ConnectionEvent;
import com.ddfplus.api.ConnectionEventType;
import com.ddfplus.net.Connection;
import com.ddfplus.net.IoChannel;
import com.ddfplus.net.SymbolProvider;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;

class IoChannelHTTPSTREAM
extends IoChannel {
    private BufferedReader in = null;

    public IoChannelHTTPSTREAM(Connection connection, SymbolProvider symbolProvider) {
        super(connection);
        if (symbolProvider == null) {
            throw new IllegalArgumentException("Symbol Provider cannot be null");
        }
        this.symbolProvider = symbolProvider;
    }

    @Override
    public void run() {
        this.isRunning = true;
        this.log.info("[INF] Started JerqSHTTPListener (HTTP Sreaming mode).");
        String symbols = this.symbolProvider.getSymbols();
        if (symbols == null || symbols.length() < 1) {
            return;
        }
        try {
            URL url = new URL("http://" + this.connection.primaryServer.getHostName() + "/stream/apstream.jsx?username=" + this.connection.username + "&password=" + this.connection.password + "&symbols=" + symbols + "&version=" + this.connection.version);
            this.log.info("HTTP URL: " + url);
            this.in = new BufferedReader(new InputStreamReader(url.openStream()));
            boolean isDone = false;
            boolean bDidEvent = false;
            while (this.isRunning && !isDone) {
                String line = this.in.readLine();
                if (line == null) {
                    isDone = true;
                    continue;
                }
                this.connection.handleMessage(line);
                if (bDidEvent) continue;
                this.connection.handleEvent(new ConnectionEvent(ConnectionEventType.CONNECTED));
                bDidEvent = true;
            }
        }
        catch (Exception e) {
            this.log.info("[SHTTP] Error streaming quotes - " + e);
            this.connection.handleEvent(new ConnectionEvent(ConnectionEventType.CONNECTION_FAILED));
        }
        this.connection.handleEvent(new ConnectionEvent(ConnectionEventType.DISCONNECTED));
        this.log.error("[INF] Stopped JerqSHTTPListener (HTTP Sreaming mode).");
        if (this.isRunning) {
            this.connection.restart();
        }
    }

    @Override
    public void disconnectAndShutdown() {
        try {
            this.isRunning = false;
            this.in.close();
        }
        catch (Exception e) {
            this.log.error("JerqHTTPListener.disconnect(): " + e);
        }
    }

    @Override
    protected void sendCommand(String cmd) {
    }
}

