/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.net;

import com.ddfplus.api.ConnectionEvent;
import com.ddfplus.api.ConnectionEventType;
import com.ddfplus.net.Connection;
import com.ddfplus.net.IoChannel;
import com.ddfplus.net.SymbolProvider;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;

class IoChannelHTTP
extends IoChannel {
    private boolean _stop = false;

    public IoChannelHTTP(Connection connection, SymbolProvider symbolProvider) {
        super(connection);
        if (symbolProvider == null) {
            throw new IllegalArgumentException("Symbol Provider cannot be null");
        }
        this.symbolProvider = symbolProvider;
    }

    @Override
    public void run() {
        this.isRunning = true;
        this.log.info("[INF] Started JerqHTTPListener (HTTP refresh mode).");
        String symbols = this.symbolProvider.getSymbols();
        if (symbols.length() > 0) {
            String url = "http://" + this.connection.primaryServer.getHostName() + "/stream/apquote.jsx?username=" + this.connection.username + "&password=" + this.connection.password + "&version=" + this.connection.version + "&symbols=" + symbols;
            this.log.info("HTTP URL: " + url);
            while (!this._stop) {
                try {
                    boolean bDidEvent = false;
                    URL u = new URL(url);
                    BufferedReader in = new BufferedReader(new InputStreamReader(u.openStream()));
                    boolean done = false;
                    while (!done) {
                        String line = in.readLine();
                        if (line == null) {
                            done = true;
                            continue;
                        }
                        this.connection.handleMessage("%" + line);
                        if (bDidEvent) continue;
                        this.connection.handleEvent(new ConnectionEvent(ConnectionEventType.CONNECTED));
                        bDidEvent = true;
                    }
                    in.close();
                    IoChannelHTTP.sleep(this.connection.getRefreshRate());
                }
                catch (Exception e) {
                    this.log.error("JerqHTTPListener.run(): " + e);
                    this.connection.handleEvent(new ConnectionEvent(ConnectionEventType.CONNECTION_FAILED));
                }
            }
        }
        this.connection.handleEvent(new ConnectionEvent(ConnectionEventType.DISCONNECTED));
        this.isRunning = false;
    }

    @Override
    public void disconnectAndShutdown() {
        this._stop = true;
    }

    @Override
    protected void sendCommand(String cmd) {
    }
}

