/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.net;

import com.ddfplus.api.BookQuoteHandler;
import com.ddfplus.api.ClientConfig;
import com.ddfplus.api.ConnectionEvent;
import com.ddfplus.api.ConnectionEventHandler;
import com.ddfplus.api.FeedHandler;
import com.ddfplus.api.MarketEventHandler;
import com.ddfplus.api.MinuteBarExchangeHandler;
import com.ddfplus.api.MinuteBarHandler;
import com.ddfplus.api.QuoteHandler;
import com.ddfplus.api.TimestampHandler;
import com.ddfplus.api.TradeHandler;
import com.ddfplus.db.BookQuote;
import com.ddfplus.db.CumulativeVolume;
import com.ddfplus.db.DataMaster;
import com.ddfplus.db.FeedEvent;
import com.ddfplus.db.MarketEvent;
import com.ddfplus.db.MasterType;
import com.ddfplus.db.Ohlc;
import com.ddfplus.db.Quote;
import com.ddfplus.enums.ConnectionType;
import com.ddfplus.messages.DdfMarketBase;
import com.ddfplus.messages.DdfMarketTrade;
import com.ddfplus.net.Connection;
import com.ddfplus.net.ConnectionHandler;
import com.ddfplus.net.DdfClient;
import com.ddfplus.net.SymbolProvider;
import com.ddfplus.net.SymbolProviderImpl;
import com.ddfplus.net.SymbolShortCuts;
import com.ddfplus.net.SymbolShortCutsImpl;
import com.ddfplus.service.definition.DefinitionService;
import com.ddfplus.service.definition.DefinitionServiceImpl;
import com.ddfplus.service.feed.FeedService;
import com.ddfplus.service.feed.FeedServiceImpl;
import com.ddfplus.service.usersettings.UserSettings;
import com.ddfplus.service.usersettings.UserSettingsService;
import com.ddfplus.service.usersettings.UserSettingsServiceImpl;
import java.net.InetAddress;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DdfClientImpl
implements DdfClient {
    private static final Logger log = LoggerFactory.getLogger(DdfClientImpl.class);
    private static Connection connection;
    private static final DataMaster dataMaster;
    private static final CopyOnWriteArrayList<ConnectionEventHandler> adminHandlers;
    private static final CopyOnWriteArrayList<FeedHandler> feedHandlers;
    private static final CopyOnWriteArrayList<MarketEventHandler> marketEventHandlers;
    private static final CopyOnWriteArrayList<TimestampHandler> timestampHandlers;
    private static final Map<String, CopyOnWriteArrayList<QuoteHandler>> quoteHandlers;
    private static final Map<String, QuoteHandler> quoteExchangeHandlers;
    private static final Map<String, TradeHandler> tradeExchangeHandlers;
    private static final Map<String, CopyOnWriteArrayList<BookQuoteHandler>> bookQuoteHandlers;
    private static final Map<String, MinuteBarHandler> minuteBarHandlers;
    private static final Map<String, MinuteBarExchangeHandler> minuteBarExchangeHandlers;
    private static int instanceId;
    private ClientConfig config;
    private String host;
    private String secondaryHost;
    private final ConnectionType type;
    private String bindInterface = null;
    private int jerqVersion = 4;
    private final String username;
    private final String password;
    private UserSettings userSettings;
    private String snapshotUserName;
    private String snapshotPassword;
    private UserSettings snapshotUserSettings;
    private UserSettingsService userSettingsService = new UserSettingsServiceImpl();
    private FeedService feedService;
    private SymbolProvider symbolProvider;
    private SymbolShortCuts symbolShortCuts;
    private DefinitionService definitionService;
    private final ScheduledExecutorService unknownSymbolScheduler = Executors.newScheduledThreadPool(1);

    public DdfClientImpl(ClientConfig config) {
        this(config, new SymbolProviderImpl());
    }

    public DdfClientImpl(ClientConfig config, SymbolProvider symbolProvider) {
        this.config = config;
        this.username = config.getUserName();
        this.password = config.getPassword();
        if (this.username == null || this.password == null) {
            throw new IllegalArgumentException("username and password have to be set");
        }
        this.type = config.getConnectionType();
        this.bindInterface = config.getBindInterface();
        this.host = config.getPrimaryServer();
        this.secondaryHost = config.getSecondaryServer();
        this.symbolProvider = symbolProvider;
        this.definitionService = new DefinitionServiceImpl();
        this.definitionService.init(config.getDefinitionRefreshIntervalSec());
        this.symbolShortCuts = new SymbolShortCutsImpl(this.definitionService);
    }

    @Override
    public void init() {
        if (this.host == null) {
            log.info("Looking up user settings for: " + this.username);
            this.userSettings = this.userSettingsService.getUserSettings(this.username, this.password);
            this.host = this.userSettings.getStreamPrimaryServer();
            if (this.host == null) {
                throw new IllegalStateException("Could not determine DDF server for user: " + this.username);
            }
        } else {
            this.userSettings = new UserSettings();
            this.userSettings.setUserName(this.username);
            this.userSettings.setPassword(this.password);
            this.userSettings.setStreamPrimaryServer(this.host);
            this.userSettings.setStreamSecondaryServer(this.secondaryHost);
        }
        if (this.snapshotUserName != null && this.snapshotPassword != null) {
            log.info("Looking up snaphot/refresh user settings for: " + this.snapshotUserName);
            this.snapshotUserSettings = this.userSettingsService.getUserSettings(this.snapshotUserName, this.snapshotPassword);
            if (this.snapshotUserSettings.getStreamPrimaryServer() == null) {
                log.warn("Could not determine Snapshot DDF server for user: " + this.snapshotUserName + " will not have snapshots for push quotes.");
            }
            this.feedService = new FeedServiceImpl(dataMaster, this.snapshotUserSettings, quoteExchangeHandlers);
            dataMaster.setFeedService(this.feedService);
        }
        log.info("Scheduling an unknown symbol lookup " + this.config.getUnknownSymbolInterval() + " every seconds.");
        UnknownSymbolThread unknownSymbolThread = new UnknownSymbolThread();
        this.unknownSymbolScheduler.scheduleAtFixedRate(unknownSymbolThread, this.config.getUnknownSymbolDeplay(), this.config.getUnknownSymbolInterval(), TimeUnit.SECONDS);
    }

    @Override
    public void setSnapshotLogin(String username, String password) {
        this.snapshotUserName = username;
        this.snapshotPassword = password;
        if (this.snapshotUserName == null || this.snapshotPassword == null) {
            throw new IllegalArgumentException("snapshot username and password have to be set");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws Exception {
        DataMaster dataMaster = DdfClientImpl.dataMaster;
        synchronized (dataMaster) {
            log.info("Trying to connect..");
            if (connection != null) {
                log.error("connection != null");
                return;
            }
            InetAddress ddfServer = InetAddress.getByName(this.userSettings.getStreamPrimaryServer());
            InetAddress secondaryServer = InetAddress.getByName(this.userSettings.getStreamSecondaryServer());
            if (this.type == ConnectionType.WS || this.type == ConnectionType.WSS) {
                ddfServer = InetAddress.getByName(this.userSettings.getWssServer());
            }
            InetAddress intf = InetAddress.getByName(this.bindInterface);
            connection = new Connection(this.type, this.username, this.password, ddfServer, this.config.getServerPort() != null ? this.config.getServerPort() : this.type.port, intf, this.symbolProvider, secondaryServer);
            connection.setVersion(this.jerqVersion);
            DdfClientConnectionHandler handler = new DdfClientConnectionHandler();
            connection.registerHandler(handler);
            log.info("Starting DdfClient#" + ++instanceId + " Version = " + connection.getVersion());
            connection.startDataStream();
        }
    }

    @Override
    public void disconnect() {
        if (connection != null) {
            log.info("Stopping DdfClient#" + ++instanceId + " Version = " + connection.getVersion());
            connection.stopDataStream();
            connection = null;
            adminHandlers.clear();
            feedHandlers.clear();
            marketEventHandlers.clear();
            timestampHandlers.clear();
            quoteHandlers.clear();
            quoteExchangeHandlers.clear();
            tradeExchangeHandlers.clear();
            bookQuoteHandlers.clear();
            minuteBarHandlers.clear();
            minuteBarExchangeHandlers.clear();
        }
    }

    @Override
    public void addConnectionEventHandler(ConnectionEventHandler handler) {
        adminHandlers.addIfAbsent(handler);
    }

    @Override
    public void removeConnectionEventHandler(ConnectionEventHandler handler) {
        adminHandlers.remove(handler);
    }

    @Override
    public void addFeedHandler(FeedHandler handler) {
        feedHandlers.addIfAbsent(handler);
    }

    @Override
    public void removeFeedHandler(FeedHandler handler) {
        feedHandlers.remove(handler);
    }

    @Override
    public void addMarketEventHandler(MarketEventHandler handler) {
        marketEventHandlers.addIfAbsent(handler);
    }

    @Override
    public void removeMarketEventHandler(MarketEventHandler handler) {
        marketEventHandlers.remove(handler);
    }

    @Override
    public void addTimestampHandler(TimestampHandler handler) {
        timestampHandlers.addIfAbsent(handler);
    }

    @Override
    public void removeTimestampHandler(TimestampHandler handler) {
        timestampHandlers.remove(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addQuoteHandler(String symbol, QuoteHandler handler) {
        String[] realSymbols = this.symbolShortCuts.resolveShortCutSymbols(symbol.trim());
        if (realSymbols.length == 0) {
            log.error("Invalid Symbol: " + symbol + " ignoring.");
            return;
        }
        for (String s : realSymbols) {
            Map<String, CopyOnWriteArrayList<QuoteHandler>> map = quoteHandlers;
            synchronized (map) {
                CopyOnWriteArrayList<QuoteHandler> l = quoteHandlers.get(s);
                if (l == null) {
                    l = new CopyOnWriteArrayList();
                    quoteHandlers.put(s, l);
                    l.add(handler);
                    this.subscribeQuote(s);
                } else {
                    boolean added = l.addIfAbsent(handler);
                    if (added) {
                        this.sendQuoteFromCache(s, handler);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeQuoteHandler(String symbol, QuoteHandler handler) {
        Map<String, CopyOnWriteArrayList<QuoteHandler>> map = quoteHandlers;
        synchronized (map) {
            CopyOnWriteArrayList<QuoteHandler> l = quoteHandlers.get(symbol);
            if (l == null) {
                return;
            }
            l.remove(handler);
            if (l.size() == 0) {
                this.unsubscribeQuote(symbol);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBookQuoteHandler(String symbol, BookQuoteHandler handler) {
        Map<String, CopyOnWriteArrayList<BookQuoteHandler>> map = bookQuoteHandlers;
        synchronized (map) {
            CopyOnWriteArrayList<BookQuoteHandler> l = bookQuoteHandlers.get(symbol);
            if (l == null) {
                l = new CopyOnWriteArrayList();
                bookQuoteHandlers.put(symbol, l);
                l.add(handler);
                this.subscribeDepth(symbol);
            } else {
                boolean added = l.addIfAbsent(handler);
                if (added) {
                    this.sendDepthFromCache(symbol, handler);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBookQuoteHandler(String symbol, BookQuoteHandler handler) {
        Map<String, CopyOnWriteArrayList<BookQuoteHandler>> map = bookQuoteHandlers;
        synchronized (map) {
            CopyOnWriteArrayList<BookQuoteHandler> l = bookQuoteHandlers.get(symbol);
            if (l == null) {
                return;
            }
            l.remove(handler);
            if (l.size() == 0) {
                this.unsubscribeDepth(symbol);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addQuoteExchangeHandler(String exchangeCode, QuoteHandler handler) {
        Map<String, QuoteHandler> map = quoteExchangeHandlers;
        synchronized (map) {
            QuoteHandler h = quoteExchangeHandlers.get(exchangeCode);
            if (h == null) {
                quoteExchangeHandlers.put(exchangeCode, handler);
                if (!tradeExchangeHandlers.containsKey(exchangeCode)) {
                    this.subscribeExchange(exchangeCode);
                }
            } else {
                log.warn("An exchange quote subscription was already active, only 1 handler is allowed per exchange, exchange: " + exchangeCode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeQuoteExchangeHandler(String exchangeCode) {
        Map<String, QuoteHandler> map = quoteExchangeHandlers;
        synchronized (map) {
            quoteExchangeHandlers.remove(exchangeCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTradeExchangeHandler(String exchangeCode, TradeHandler handler) {
        Map<String, TradeHandler> map = tradeExchangeHandlers;
        synchronized (map) {
            TradeHandler h = tradeExchangeHandlers.get(exchangeCode);
            if (h == null) {
                tradeExchangeHandlers.put(exchangeCode, handler);
                if (!quoteExchangeHandlers.containsKey(exchangeCode)) {
                    this.subscribeExchange(exchangeCode);
                }
            } else {
                log.warn("An exchange trade subscription was already active, only 1 handler is allowed per exchange, exchange: " + exchangeCode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTradeExchangeHandler(String exchangeCode) {
        Map<String, TradeHandler> map = tradeExchangeHandlers;
        synchronized (map) {
            tradeExchangeHandlers.remove(exchangeCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMinuteBarHandler(String symbol, MinuteBarHandler handler) {
        Map<String, MinuteBarHandler> map = minuteBarHandlers;
        synchronized (map) {
            MinuteBarHandler h = minuteBarHandlers.get(symbol);
            if (h == null) {
                minuteBarHandlers.put(symbol, handler);
                this.subscribeMinuteBar(symbol);
            } else {
                log.warn("A minute bar subscription was already active, only 1 handler is allowed per symbol, symbol: " + symbol);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMinuteBarHandler(String symbol) {
        Map<String, MinuteBarHandler> map = minuteBarHandlers;
        synchronized (map) {
            minuteBarHandlers.remove(symbol);
            this.unSubscribeMinuteBar(symbol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMinuteBarExchangeHandler(String exchange, MinuteBarExchangeHandler handler) {
        Map<String, MinuteBarExchangeHandler> map = minuteBarExchangeHandlers;
        synchronized (map) {
            MinuteBarExchangeHandler h = minuteBarExchangeHandlers.get(exchange);
            if (h == null) {
                minuteBarExchangeHandlers.put(exchange, handler);
                this.subscribeMinuteBarExchange(exchange);
            } else {
                log.warn("A minute bar subscription was already active, only 1 handler is allowed per exchange, exchange: " + exchange);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMinuteBarExchangeHandler(String exch) {
        Map<String, MinuteBarExchangeHandler> map = minuteBarExchangeHandlers;
        synchronized (map) {
            minuteBarExchangeHandlers.remove(exch);
            this.unSubscribeMinuteBarExchange(exch);
        }
    }

    @Override
    public Quote getQuote(String symbol) {
        return dataMaster.getQuote(symbol);
    }

    @Override
    public BookQuote getBookQuote(String symbol) {
        return dataMaster.getBookQuote(symbol);
    }

    @Override
    public CumulativeVolume getCumulativeVolume(String symbol) {
        return dataMaster.getCumulativeVolume(symbol);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getJerqVersion() {
        return this.jerqVersion;
    }

    public void setJerqVersion(int jerqVersion) {
        this.jerqVersion = jerqVersion;
    }

    private void subscribeDepth(String symbol) {
        connection.subscribeDepth(symbol);
        dataMaster.addSubscribedSymbol(symbol);
    }

    private void unsubscribeDepth(String symbol) {
        connection.unsubscribeDepth(symbol);
        dataMaster.removeSubscribedSymbol(symbol);
    }

    private void sendDepthFromCache(String symbol, BookQuoteHandler handler) {
        BookQuote depth = dataMaster.getBookQuote(symbol);
        if (depth != null) {
            handler.onBookQuote(depth);
        }
    }

    private void subscribeQuote(String symbol) {
        connection.subscribeQuote(symbol);
        dataMaster.addSubscribedSymbol(symbol);
    }

    private void unsubscribeQuote(String symbol) {
        connection.unsubscribeQuote(symbol);
        dataMaster.removeSubscribedSymbol(symbol);
    }

    private void subscribeExchange(String exchangeCode) {
        connection.subscribeExchange(exchangeCode);
    }

    private void subscribeMinuteBar(String symbol) {
        connection.subscribeMinuteBar(symbol);
    }

    private void unSubscribeMinuteBar(String symbol) {
        connection.unsubscribeMinuteBar(symbol);
    }

    private void subscribeMinuteBarExchange(String exchange) {
        String[] syms;
        for (String s : syms = this.definitionService.getExchangeSymbols(exchange)) {
            this.subscribeMinuteBar(s);
        }
    }

    private void unSubscribeMinuteBarExchange(String exchange) {
        String[] syms;
        for (String s : syms = this.definitionService.getExchangeSymbols(exchange)) {
            this.unSubscribeMinuteBar(s);
        }
    }

    private void sendQuoteFromCache(String symbol, QuoteHandler handler) {
        Quote quote = dataMaster.getQuote(symbol);
        if (quote != null) {
            handler.onQuote(quote);
        }
    }

    static {
        dataMaster = new DataMaster(MasterType.Realtime);
        adminHandlers = new CopyOnWriteArrayList();
        feedHandlers = new CopyOnWriteArrayList();
        marketEventHandlers = new CopyOnWriteArrayList();
        timestampHandlers = new CopyOnWriteArrayList();
        quoteHandlers = new ConcurrentHashMap<String, CopyOnWriteArrayList<QuoteHandler>>();
        quoteExchangeHandlers = new ConcurrentHashMap<String, QuoteHandler>();
        tradeExchangeHandlers = new ConcurrentHashMap<String, TradeHandler>();
        bookQuoteHandlers = new ConcurrentHashMap<String, CopyOnWriteArrayList<BookQuoteHandler>>();
        minuteBarHandlers = new ConcurrentHashMap<String, MinuteBarHandler>();
        minuteBarExchangeHandlers = new ConcurrentHashMap<String, MinuteBarExchangeHandler>();
        instanceId = 0;
    }

    private class UnknownSymbolThread
    implements Runnable {
        private UnknownSymbolThread() {
        }

        @Override
        public void run() {
            if (log.isDebugEnabled()) {
                log.debug("Running unknown symbol thread.");
            }
            for (String s : dataMaster.getUnknownSymbols()) {
                connection.subscribeQuoteSnapshot(s);
            }
        }
    }

    private class DdfClientConnectionHandler
    implements ConnectionHandler {
        private DdfClientConnectionHandler() {
        }

        @Override
        public void onConnectionEvent(ConnectionEvent event) {
            for (ConnectionEventHandler listener : adminHandlers) {
                listener.onEvent(event);
            }
        }

        @Override
        public void onMessage(byte[] array) {
            Object h5;
            Object e3;
            FeedEvent fe = dataMaster.processMessage(array);
            if (fe == null) {
                return;
            }
            if (fe.isDdfMessage()) {
                for (FeedHandler h2 : feedHandlers) {
                    try {
                        h2.onMessage(fe.getDdfMessage());
                    }
                    catch (Exception e2) {
                        log.error("DdfClient.onMessage(" + array + ") failed on onMessage. " + e2);
                    }
                }
            }
            if (fe.isTrade()) {
                DdfMarketTrade trade = fe.getTrade();
                char ddfExchange = trade.getExchange();
                TradeHandler tradeExchangeHandler = (TradeHandler)tradeExchangeHandlers.get(Character.toString(ddfExchange));
                if (tradeExchangeHandler != null) {
                    try {
                        tradeExchangeHandler.onTrade(trade);
                    }
                    catch (Exception e3) {
                        log.error("exchangeTrade(" + array + ") failed on onMessage. " + e3);
                    }
                }
            }
            if (fe.isQuote()) {
                TradeHandler tradeExchangeHandler;
                Quote q = fe.getQuote();
                String symbol = q.getSymbolInfo().getSymbol();
                CopyOnWriteArrayList handlers = (CopyOnWriteArrayList)quoteHandlers.get(symbol);
                if (handlers != null) {
                    e3 = handlers.iterator();
                    while (e3.hasNext()) {
                        QuoteHandler h3 = (QuoteHandler)e3.next();
                        try {
                            h3.onQuote(q);
                        }
                        catch (Exception e4) {
                            log.error("quote(" + array + ") failed on onMessage. " + e4);
                        }
                    }
                } else {
                    log.debug("Quote handler not found for symbol: {} msg: {}", (Object)q.getSymbolInfo().getSymbol(), (Object)q.getMessage());
                }
                String ddfExchange = q.getDDFExchange();
                QuoteHandler eh = (QuoteHandler)quoteExchangeHandlers.get(ddfExchange);
                if (eh != null) {
                    try {
                        eh.onQuote(q);
                    }
                    catch (Exception e5) {
                        log.error("exchangeQuote(" + array + ") failed on onMessage. " + e5);
                    }
                }
                if ((tradeExchangeHandler = (TradeHandler)tradeExchangeHandlers.get(ddfExchange)) != null) {
                    try {
                        DdfMarketBase ddf = q.getMessage();
                        if (ddf instanceof DdfMarketTrade) {
                            DdfMarketTrade trade = (DdfMarketTrade)ddf;
                            char sessionCondition = trade.getSession();
                            tradeExchangeHandler.onTrade(trade);
                        }
                    }
                    catch (Exception e6) {
                        log.error("exchangeTrade(" + array + ") failed on onMessage. " + e6);
                    }
                }
            }
            if (fe.isBookQuote()) {
                BookQuote bq = fe.getBook();
                CopyOnWriteArrayList handlers = (CopyOnWriteArrayList)bookQuoteHandlers.get(bq.getSymbol());
                if (handlers != null) {
                    for (BookQuoteHandler h4 : handlers) {
                        try {
                            h4.onBookQuote(bq);
                        }
                        catch (Exception e7) {
                            log.error("bookQuote(" + array + ") failed on onMessage. " + e7);
                        }
                    }
                }
            }
            if (fe.isTimestamp()) {
                Date ts = fe.getTimestamp();
                for (Object h5 : timestampHandlers) {
                    try {
                        h5.onTimestamp(ts);
                    }
                    catch (Exception e8) {
                        log.error("timestamp(" + array + ") failed on onMessage. " + e8);
                    }
                }
            }
            if (fe.isCumVolume()) {
                // empty if block
            }
            if (fe.isMarketEvents()) {
                for (MarketEventHandler h6 : marketEventHandlers) {
                    try {
                        h5 = fe.getMarketEvents().iterator();
                        while (h5.hasNext()) {
                            e3 = (MarketEvent)h5.next();
                            h6.onEvent((MarketEvent)e3);
                        }
                    }
                    catch (Exception e9) {
                        log.error("marketEvent(" + array + ") failed on onMessage. " + e9);
                    }
                }
            }
            if (fe.isOhlc()) {
                MinuteBarHandler mh;
                Ohlc ohlc = fe.getOhlc();
                String exchange = DdfClientImpl.this.definitionService.getExchange(ohlc.getSymbol());
                if (exchange != null && (h5 = (MinuteBarExchangeHandler)minuteBarExchangeHandlers.get(exchange)) != null) {
                    try {
                        ohlc.setExchange(exchange);
                        h5.onOhlc(ohlc);
                    }
                    catch (Exception e10) {
                        log.error("minuteBarExchange(" + array + ") failed on onOhlc. " + e10);
                    }
                }
                if ((mh = (MinuteBarHandler)minuteBarHandlers.get(ohlc.getSymbol())) != null) {
                    try {
                        mh.onOhlc(ohlc);
                    }
                    catch (Exception e11) {
                        log.error("minuteBar(" + array + ") failed on onOhlc. " + e11);
                    }
                }
            }
        }
    }
}

