/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.net;

import com.ddfplus.api.ConnectionEvent;
import com.ddfplus.api.ConnectionEventType;
import com.ddfplus.enums.ConnectionType;
import com.ddfplus.net.Cmd;
import com.ddfplus.net.ConnectionHandler;
import com.ddfplus.net.IoChannel;
import com.ddfplus.net.IoChannelHTTP;
import com.ddfplus.net.IoChannelHTTPSTREAM;
import com.ddfplus.net.IoChannelListenTCP;
import com.ddfplus.net.IoChannelListenUDP;
import com.ddfplus.net.IoChannelTCP;
import com.ddfplus.net.IoChannelUDP;
import com.ddfplus.net.IoChannelWSS;
import com.ddfplus.net.SymbolProvider;
import com.ddfplus.net.XQueue;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection {
    private static final int READER_THREAD_WAIT_MS = 1000;
    private static final long RESTART_INTERVAL_MS = 10000L;
    private static final Logger log = LoggerFactory.getLogger(Connection.class);
    protected InetAddress primaryServer;
    protected InetAddress secondaryServer;
    protected int port;
    protected InetAddress intf;
    protected String password = "";
    protected String username = "";
    protected int version = 1;
    private ConnectionType type = ConnectionType.TCP;
    private IoChannel channel;
    private boolean bDoStop = false;
    private String _id = "";
    private final List<ConnectionHandler> handlerList = new CopyOnWriteArrayList<ConnectionHandler>();
    private long _refreshRate = 5000L;
    private volatile long _totalDDFMessageCount = 0L;
    private XQueue _queue = null;
    private boolean _useQueue = false;
    private SymbolProvider symbolProvider;

    public Connection(ConnectionType type, String username, String password, InetAddress primaryServer, int port, InetAddress intf, SymbolProvider symbolProvider, InetAddress secondaryServer) {
        this.username = username;
        this.password = password;
        this.type = type;
        this.primaryServer = primaryServer;
        this.port = port;
        this.intf = intf;
        this.symbolProvider = symbolProvider;
        this.secondaryServer = secondaryServer;
    }

    public Connection(ConnectionType mode, String username, String password, String server) throws IllegalArgumentException, UnknownHostException {
        this.username = username;
        this.password = password;
        this.primaryServer = InetAddress.getByName(server);
        this.type = mode;
    }

    public Connection(ConnectionType mode, InetAddress addr, int port, InetAddress intf) throws IllegalArgumentException {
        switch (mode) {
            case LISTEN_UDP: 
            case LISTEN_TCP: {
                this.type = mode;
                this.primaryServer = addr;
                this.port = port;
                this.intf = intf;
                break;
            }
            default: {
                throw new IllegalArgumentException("The constructor requires a one-way type mode:" + ConnectionType.LISTEN_TCP + " or " + ConnectionType.LISTEN_UDP);
            }
        }
    }

    public void registerHandler(ConnectionHandler handler) {
        ((CopyOnWriteArrayList)this.handlerList).addIfAbsent(handler);
    }

    public void unregisterHandler(ConnectionHandler handler) {
        this.handlerList.remove(handler);
    }

    public void subscribeQuote(String symbol) {
        Cmd cmd = new Cmd("GO", symbol, "SsV");
        this.channel.enqueueCommand(cmd);
    }

    public void unsubscribeQuote(String symbol) {
        Cmd cmd = new Cmd("STOP", symbol, "Ss");
        this.channel.enqueueCommand(cmd);
    }

    public void subscribeQuoteSnapshot(String symbol) {
        Cmd cmd = new Cmd("GO", symbol, "s");
        this.channel.enqueueCommand(cmd);
    }

    public void subscribeDepth(String symbol) {
        Cmd cmd = new Cmd("GO", symbol, "Bb");
        this.channel.enqueueCommand(cmd);
    }

    public void unsubscribeDepth(String symbol) {
        Cmd cmd = new Cmd("STOP", symbol, "Bb");
        this.channel.enqueueCommand(cmd);
    }

    public void subscribeExchange(String exchangeCode) {
        Cmd cmd = new Cmd("STR", exchangeCode);
        this.channel.enqueueCommand(cmd);
    }

    public void subscribeMinuteBar(String symbol) {
        Cmd cmd = new Cmd("GO", symbol, "O");
        this.channel.enqueueCommand(cmd);
    }

    public void unsubscribeMinuteBar(String symbol) {
        Cmd cmd = new Cmd("STOP", symbol, "O");
        this.channel.enqueueCommand(cmd);
    }

    public synchronized void startDataStream() {
        this.stopDataStream();
        if (this.handlerList.isEmpty()) {
            log.warn("ConnectionHandlers are empty, not starting connection.");
            return;
        }
        if (this.channel == null) {
            switch (this.type) {
                case UDP: {
                    this.channel = new IoChannelUDP(this, this.symbolProvider);
                    break;
                }
                case TCP: {
                    this.channel = new IoChannelTCP(this);
                    break;
                }
                case HTTP: {
                    this.channel = new IoChannelHTTP(this, this.symbolProvider);
                    break;
                }
                case HTTPSTREAM: {
                    this.channel = new IoChannelHTTPSTREAM(this, this.symbolProvider);
                    break;
                }
                case LISTEN_UDP: {
                    this.channel = new IoChannelListenUDP(this);
                    break;
                }
                case LISTEN_TCP: {
                    this.channel = new IoChannelListenTCP(this);
                    break;
                }
                case WS: 
                case WSS: {
                    this.channel = new IoChannelWSS(this);
                    break;
                }
                default: {
                    this.channel = new IoChannelTCP(this);
                }
            }
            this.channel.start();
        }
    }

    public void stopDataStream() {
        this.bDoStop = true;
        if (this.channel != null) {
            try {
                this.channel.disconnectAndShutdown();
                this.channel.join(1000L);
            }
            catch (InterruptedException ie) {
                log.error("Connection.stopDataStream(): " + ie);
            }
        }
        this.channel = null;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String value) {
        this._id = value;
    }

    public int getMaxQueueSize() {
        int size = 0;
        if (this.channel != null) {
            size = this.channel.getMaxQueueSize();
        }
        return size;
    }

    public int getQueueSize() {
        int size = 0;
        if (this.channel != null) {
            size = this.channel.getQueueSize();
        }
        return size;
    }

    public long getTotalDDFMessageCount() {
        return this._totalDDFMessageCount;
    }

    public boolean getUseQueue() {
        return this._useQueue;
    }

    public void setUseQueue(boolean value) {
        this._useQueue = value;
        if (this._useQueue) {
            this._queue = new XQueue(this);
        }
    }

    public void newQueueMessage(byte[] array) {
        this.pumpMessage(array);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setThreadPriority(int priority) {
        if (this.channel == null) {
            log.error("Connection.setPriority(): listener == null");
        } else if (priority < 1 || priority > 10) {
            log.error("Connection.setPriority(): priority is out of range");
        } else {
            this.channel.setPriority(priority);
        }
    }

    public int getThreadPriority() {
        if (this.channel == null) {
            log.error("Connection.getPriority(): listener == null");
            return -1;
        }
        return this.channel.getPriority();
    }

    public String getThreadName() {
        if (this.channel == null) {
            log.error("Connection.getThreadName(): listener == null");
            return null;
        }
        return this.channel.getName();
    }

    public void setThreadName(String name) {
        if (this.channel == null) {
            log.error("Connection.setThreadName(): listener == null");
        } else {
            this.channel.setName(name);
        }
    }

    public ConnectionType getConnectionType() {
        return this.type;
    }

    public int getPort() {
        return this.port;
    }

    protected void handleEvent(ConnectionEvent event) {
        for (ConnectionHandler handler : this.handlerList) {
            try {
                handler.onConnectionEvent(event);
            }
            catch (Exception e) {
                log.error("Connection.handleEvent(" + event + ")", (Throwable)e);
            }
        }
    }

    protected void handleMessage(String message) {
        byte[] array = new byte[message.length()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (byte)message.charAt(i);
        }
        if (this._useQueue) {
            this._queue.add(array);
        } else {
            this.pumpMessage(array);
        }
    }

    protected long getRefreshRate() {
        return this._refreshRate;
    }

    protected void restart() {
        if (!this.bDoStop) {
            return;
        }
        try {
            Thread.sleep(10000L);
            this.startDataStream();
        }
        catch (Exception e) {
            log.error("Connection.restart(): " + e);
            this.restart();
        }
    }

    private void pumpMessage(byte[] array) {
        String message;
        if (array == null || array.length < 1) {
            return;
        }
        ++this._totalDDFMessageCount;
        if ((char)array[0] == 'C' && (message = new String(array)).startsWith("CLockout")) {
            this.stopDataStream();
            this.handleEvent(new ConnectionEvent(ConnectionEventType.USER_LOCKOUT));
            return;
        }
        for (ConnectionHandler handler : this.handlerList) {
            try {
                handler.onMessage(array);
            }
            catch (Exception e) {
                log.error("Connection.pumpMesage(" + new String(array) + "): " + e);
            }
        }
    }
}

