/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.messages;

import com.ddfplus.codec.Codec;
import com.ddfplus.enums.QuoteType;
import com.ddfplus.messages.AbstractMsgBaseMarket;
import com.ddfplus.messages.DdfMarketSummary;
import com.ddfplus.util.DDFDate;
import java.time.ZonedDateTime;

public class Data3XSummary
extends AbstractMsgBaseMarket
implements DdfMarketSummary {
    public volatile Float _open = null;
    public volatile Float _high = null;
    public volatile Float _low = null;
    public volatile Float _close = null;
    public volatile Long _volume = null;
    public volatile Long _openInterest = null;

    Data3XSummary(byte[] message) {
        super(message);
    }

    @Override
    public float getClose() {
        return this._close == null ? 0.0f : this._close.floatValue();
    }

    long getDateAsMillis() {
        return this.millisCST;
    }

    @Override
    public float getHigh() {
        return this._high == null ? 0.0f : this._high.floatValue();
    }

    @Override
    public float getLow() {
        return this._low == null ? 0.0f : this._low.floatValue();
    }

    @Override
    public float getOpen() {
        return this._open == null ? 0.0f : this._open.floatValue();
    }

    @Override
    public long getOpenInterest() {
        return this._openInterest == null ? 0L : this._openInterest;
    }

    @Override
    public long getVolume() {
        return this._volume == null ? 0L : this._volume;
    }

    public static Data3XSummary Parse(byte[] ba) {
        Data3XSummary message = new Data3XSummary(ba);
        message._record = (char)ba[1];
        int pos = Codec.getIndexOf(ba, ',', 0);
        message._subrecord = (char)ba[pos + 1];
        message._symbol = new String(ba, 2, pos - 2);
        message._basecode = (char)ba[pos + 3];
        message._exchange = (char)ba[pos + 4];
        int month = Codec.parseIntValue(ba, pos + 8, 2);
        int date = Codec.parseIntValue(ba, pos + 11, 2);
        int year = Codec.parseIntValue(ba, pos + 14, 4);
        message.millisCST = ZonedDateTime.of(year, month, date, 0, 0, 0, 0, DDFDate._zoneChicago).toInstant().toEpochMilli();
        pos += 19;
        if (message._subrecord == 'C') {
            int pos2 = Codec.getIndexOf(ba, ',', pos);
            message._open = Float.valueOf(Codec.parseDDFPriceValue(ba, pos, pos2 - pos, message._basecode));
            pos = pos2 + 1;
            pos2 = Codec.getIndexOf(ba, ',', pos);
            message._high = Float.valueOf(Codec.parseDDFPriceValue(ba, pos, pos2 - pos, message._basecode));
            pos = pos2 + 1;
            pos2 = Codec.getIndexOf(ba, ',', pos);
            message._low = Float.valueOf(Codec.parseDDFPriceValue(ba, pos, pos2 - pos, message._basecode));
            pos = pos2 + 1;
            message._close = Float.valueOf(Codec.parseDDFPriceValue(ba, pos, ba.length - pos - 1, message._basecode));
        } else if (message._subrecord == 'S') {
            int pos2 = Codec.getIndexOf(ba, ',', pos);
            message._open = Float.valueOf(Codec.parseDDFPriceValue(ba, pos, pos2 - pos, message._basecode));
            pos = pos2 + 1;
            pos2 = Codec.getIndexOf(ba, ',', pos);
            message._high = Float.valueOf(Codec.parseDDFPriceValue(ba, pos, pos2 - pos, message._basecode));
            pos = pos2 + 1;
            pos2 = Codec.getIndexOf(ba, ',', pos);
            message._low = Float.valueOf(Codec.parseDDFPriceValue(ba, pos, pos2 - pos, message._basecode));
            pos = pos2 + 1;
            pos2 = Codec.getIndexOf(ba, ',', pos);
            message._close = Float.valueOf(Codec.parseDDFPriceValue(ba, pos, pos2 - pos, message._basecode));
            pos = pos2 + 1;
            message._volume = Codec.parseDDFIntValue(ba, pos, ba.length - pos - 1);
        } else if (message._subrecord == 'I') {
            int pos2 = Codec.getIndexOf(ba, ',', pos);
            message._volume = Codec.parseLongValue(ba, pos, pos2 - pos);
            pos = pos2 + 1;
            message._openInterest = Codec.parseLongValue(ba, pos, ba.length - pos - 1);
        } else if (message._subrecord == 'T') {
            int pos2 = Codec.getIndexOf(ba, ',', pos);
            message._volume = Codec.parseLongValue(ba, pos, pos2 - pos);
            pos = pos2 + 1;
            message._openInterest = Codec.parseLongValue(ba, pos, ba.length - pos - 1);
        }
        return message;
    }

    @Override
    public QuoteType getQuoteType() {
        return QuoteType.SUMMARY;
    }
}

