/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.messages;

import com.ddfplus.codec.Codec;
import com.ddfplus.enums.QuoteType;
import com.ddfplus.messages.AbstractMsgBaseMarket;
import com.ddfplus.messages.DdfMarketDepth;

public class Data3BOrderBook
extends AbstractMsgBaseMarket
implements DdfMarketDepth {
    public volatile int _askCount = 0;
    public final float[] _askPrices = new float[10];
    public final int[] _askSizes = new int[10];
    public volatile int _bidCount = 0;
    public final float[] _bidPrices = new float[10];
    public final int[] _bidSizes = new int[10];

    Data3BOrderBook(byte[] message) {
        super(message);
    }

    @Override
    public int getAskCount() {
        return this._askCount;
    }

    @Override
    public int getBidCount() {
        return this._bidCount;
    }

    @Override
    public float[] getAskPrices() {
        return this._askPrices;
    }

    @Override
    public int[] getAskSizes() {
        return this._askSizes;
    }

    @Override
    public float[] getBidPrices() {
        return this._bidPrices;
    }

    @Override
    public int[] getBidSizes() {
        return this._bidSizes;
    }

    public static Data3BOrderBook Parse(byte[] ba) {
        Data3BOrderBook msg = new Data3BOrderBook(ba);
        int pos = Codec.getIndexOf(ba, ',', 0);
        msg._symbol = Codec.parseStringValue(ba, 2, pos - 2);
        msg.setBaseCode((char)ba[pos + 3]);
        msg._exchange = (char)ba[pos + 4];
        msg._record = (char)ba[1];
        msg._subrecord = (char)ba[pos + 1];
        msg._bidCount = (char)ba[pos + 5] == 'A' ? 10 : ba[pos + 5] - 48;
        msg._askCount = (char)ba[pos + 6] == 'A' ? 10 : ba[pos + 6] - 48;
        if (ba.length < pos + 9) {
            return msg;
        }
        pos += 8;
        boolean more = true;
        while (more) {
            int pos2 = Codec.getIndexOf(ba, ',', pos);
            if (pos2 == -1) {
                pos2 = ba.length - 1;
                more = false;
            }
            int xx = 0;
            for (xx = pos; xx < pos2; ++xx) {
                int i;
                if (ba[xx] >= 75 && ba[xx] <= 90) {
                    i = ba[xx] - 75;
                    msg._bidPrices[i] = Codec.parseDDFPriceValue(ba, pos, xx - pos, msg._basecode);
                    msg._bidSizes[i] = Codec.parseIntValue(ba, xx + 1, pos2 - xx - 1);
                    continue;
                }
                if (ba[xx] < 65 || ba[xx] > 74) continue;
                i = 9 - (ba[xx] - 65);
                msg._askPrices[i] = Codec.parseDDFPriceValue(ba, pos, xx - pos, msg._basecode);
                msg._askSizes[i] = Codec.parseIntValue(ba, xx + 1, pos2 - xx - 1);
            }
            pos = pos2 + 1;
        }
        return msg;
    }

    @Override
    public QuoteType getQuoteType() {
        return QuoteType.BOOK;
    }
}

