/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.messages;

import com.ddfplus.codec.Codec;
import com.ddfplus.enums.QuoteType;
import com.ddfplus.messages.AbstractMsgBaseMarket;
import com.ddfplus.messages.DdfMarketTrade;

public class Data27Trade
extends AbstractMsgBaseMarket
implements DdfMarketTrade {
    public volatile Float _tradePrice = null;
    public volatile Integer _tradeSize = null;

    public Data27Trade(byte[] message) {
        super(message);
    }

    @Override
    public float getTradePrice() {
        return this._tradePrice == null ? 0.0f : this._tradePrice.floatValue();
    }

    @Override
    public int getTradeSize() {
        return this._tradeSize == null ? 0 : this._tradeSize;
    }

    protected void parse(byte[] ba) {
        int pos = Codec.getIndexOf(ba, ',', 0);
        this._symbol = Codec.parseStringValue(ba, 2, pos - 2);
        this.setBaseCode((char)ba[pos + 3]);
        this._exchange = (char)ba[pos + 4];
        this._delay = Codec.parseIntValue(ba, pos + 5, 2);
        this._record = (char)ba[1];
        this._subrecord = (char)ba[pos + 1];
        int pos2 = Codec.getIndexOf(ba, ',', pos + 7);
        this._tradePrice = Float.valueOf(Codec.parseDDFPriceValue(ba, pos + 7, pos2 - pos - 7, this._basecode));
        pos = Codec.getIndexOf(ba, ',', pos2 + 1);
        this._tradeSize = Codec.parseDDFIntValue(ba, pos2 + 1, pos - pos2 - 1);
        pos = Codec.getIndexOf(ba, '\u0003', pos);
        this._day = (char)ba[pos - 2];
        this._session = (char)ba[pos - 1];
        this.setMessageTimestamp(pos);
    }

    public static Data27Trade Parse(byte[] ba) {
        Data27Trade msg = new Data27Trade(ba);
        msg.parse(ba);
        return msg;
    }

    @Override
    public QuoteType getQuoteType() {
        return QuoteType.TICK;
    }
}

