/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.messages;

import com.ddfplus.codec.Codec;
import com.ddfplus.db.SymbolInfo;
import com.ddfplus.enums.QuoteType;
import com.ddfplus.messages.AbstractMsgBaseMarket;
import com.ddfplus.messages.DdfMarketRefresh;

public class Data21Refresh
extends AbstractMsgBaseMarket
implements DdfMarketRefresh {
    public volatile Float _ask = null;
    public volatile Float _bid = null;
    public volatile Float _close = null;
    public volatile Float _close2 = null;
    public volatile Float _high = null;
    public volatile Float _last = null;
    public volatile Float _low = null;
    public volatile Float _open = null;
    public volatile Float _open2 = null;
    public volatile Long _openInterest = null;
    public volatile Float _previous = null;
    public volatile Long _previousVolume = null;
    public volatile Float _settle = null;
    public volatile Long _volume = null;

    Data21Refresh(byte[] message) {
        super(message);
    }

    @Override
    public Float getAsk() {
        return this._ask;
    }

    @Override
    public Float getBid() {
        return this._bid;
    }

    @Override
    public Float getClose() {
        return this._close;
    }

    @Override
    public Float getClose2() {
        return this._close2;
    }

    @Override
    public Float getHigh() {
        return this._high;
    }

    @Override
    public Float getLast() {
        return this._last;
    }

    @Override
    public Float getLow() {
        return this._low;
    }

    @Override
    public Float getOpen() {
        return this._open;
    }

    @Override
    public Float getOpen2() {
        return this._open2;
    }

    @Override
    public Long getOpenInterest() {
        return this._openInterest;
    }

    @Override
    public Float getPrevious() {
        return this._previous;
    }

    @Override
    public Long getPreviousVolume() {
        return this._previousVolume;
    }

    @Override
    public Float getSettle() {
        return this._settle;
    }

    @Override
    public Long getVolume() {
        return this._volume;
    }

    protected void parse(byte[] ba) {
        int pos = Codec.getIndexOf(ba, ',', 0);
        this._symbol = new String(ba, 2, pos - 2);
        this.setBaseCode((char)ba[pos + 3]);
        int unitCode = SymbolInfo.ddfuc2bb((char)ba[pos + 3]);
        this._exchange = (char)ba[pos + 4];
        this._delay = Codec.parseIntValue(ba, pos + 5, 2);
        this._record = (char)ba[1];
        this._subrecord = (char)ba[pos + 1];
        int pos2 = pos + 8;
        int idx = -1;
        while (idx++ < 15) {
            if (idx == 14) {
                this._day = (char)ba[pos + 1];
                this._session = (char)ba[pos + 2];
                break;
            }
            pos = Codec.getIndexOf(ba, ',', pos2);
            Float fvalue = null;
            Long lvalue = null;
            if (pos > pos2) {
                if (pos - pos2 == 1 && (char)ba[pos2] == '-') {
                    fvalue = Float.valueOf(0.0f);
                } else if (idx <= 10) {
                    fvalue = Float.valueOf(Codec.parseDDFPriceValue(ba, pos2, pos - pos2, unitCode));
                } else {
                    lvalue = Codec.parseLongValue(ba, pos2, pos - pos2);
                }
            }
            pos2 = pos + 1;
            switch (idx) {
                case 0: {
                    this._open = fvalue;
                    break;
                }
                case 1: {
                    this._high = fvalue;
                    break;
                }
                case 2: {
                    this._low = fvalue;
                    break;
                }
                case 3: {
                    this._last = fvalue;
                    break;
                }
                case 4: {
                    this._bid = fvalue;
                    break;
                }
                case 5: {
                    this._ask = fvalue;
                    break;
                }
                case 6: {
                    this._open2 = fvalue;
                    break;
                }
                case 7: {
                    this._previous = fvalue;
                    break;
                }
                case 8: {
                    this._close = fvalue;
                    break;
                }
                case 9: {
                    this._close2 = fvalue;
                    break;
                }
                case 10: {
                    this._settle = fvalue;
                    break;
                }
                case 11: {
                    this._previousVolume = lvalue;
                    break;
                }
                case 12: {
                    this._openInterest = lvalue;
                    break;
                }
                case 13: {
                    this._volume = lvalue;
                }
            }
        }
        if ((pos = Codec.getIndexOf(ba, '\u0003', pos2)) > 0 && ba.length - 10 == pos) {
            this.setMessageTimestamp(pos);
        }
    }

    public static Data21Refresh Parse(byte[] ba) {
        Data21Refresh msg = new Data21Refresh(ba);
        msg.parse(ba);
        return msg;
    }

    @Override
    public QuoteType getQuoteType() {
        switch (this._subrecord) {
            case '1': 
            case '2': 
            case '3': {
                return QuoteType.REFRESH;
            }
            case '6': {
                return QuoteType.TICK;
            }
        }
        return QuoteType.UNKNOWN;
    }
}

