/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.messages;

import com.ddfplus.codec.Codec;
import com.ddfplus.enums.DdfMessageType;
import com.ddfplus.enums.QuoteType;
import com.ddfplus.messages.AbstractMsgBaseMarket;
import com.ddfplus.messages.DdfMarketParameter;
import com.ddfplus.util.ParserHelper;

public class Data20Parameter
extends AbstractMsgBaseMarket
implements DdfMarketParameter {
    public volatile char _element = '\u0000';
    public volatile char _modifier = '\u0000';
    public volatile Number _value = null;

    Data20Parameter(byte[] message) {
        super(message);
    }

    @Override
    public char getElement() {
        return this._element;
    }

    @Override
    public char getModifier() {
        return this._modifier;
    }

    @Override
    public Number getValue() {
        return this._value;
    }

    @Override
    public float getValueAsFloat() {
        return this._value == null ? 0.0f : this._value.floatValue();
    }

    @Override
    public int getValueAsInteger() {
        return this._value == null ? 0 : this._value.intValue();
    }

    protected void parse(byte[] ba) {
        int pos = Codec.getIndexOf(ba, ',', 0);
        this._symbol = Codec.parseStringValue(ba, 2, pos - 2);
        this.setBaseCode((char)ba[pos + 3]);
        this._exchange = (char)ba[pos + 4];
        this._delay = Codec.parseIntValue(ba, pos + 5, 2);
        this._record = (char)ba[1];
        this._subrecord = (char)ba[pos + 1];
        int pos2 = Codec.getIndexOf(ba, ',', pos + 7);
        this._element = (char)ba[pos2 + 1];
        this._modifier = (char)ba[pos2 + 2];
        boolean isFloat = false;
        switch (this._element) {
            case '0': {
                isFloat = true;
                break;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case 'A': 
            case 'D': 
            case 'E': 
            case 'V': 
            case 'd': {
                isFloat = true;
                break;
            }
            default: {
                isFloat = false;
            }
        }
        this._value = isFloat ? (Number)Float.valueOf(Codec.parseDDFPriceValue(ba, pos + 7, pos2 - pos - 7, this._basecode)) : (Number)Codec.parseDDFIntValue(ba, pos + 7, pos2 - pos - 7);
        this._day = (char)ba[pos2 + 3];
        this._session = (char)ba[pos2 + 4];
        this.setMessageTimestamp(pos2 + 5);
    }

    public static Data20Parameter Parse(byte[] ba) {
        Data20Parameter msg = new Data20Parameter(ba);
        msg.parse(ba);
        return msg;
    }

    @Override
    protected void appendConcrete(StringBuilder text) {
        text.append(" element=");
        text.append(ParserHelper.filterNullChar(this._element));
        text.append(" modifier=");
        text.append(ParserHelper.filterNullChar(this._modifier));
        text.append(" value=");
        text.append(this._value);
    }

    @Override
    public QuoteType getQuoteType() {
        switch (this._element) {
            case '0': {
                switch (this._modifier) {
                    case '0': 
                    case '1': 
                    case '2': {
                        return QuoteType.TICK;
                    }
                }
                break;
            }
            case 'D': {
                switch (this._modifier) {
                    case '0': {
                        return QuoteType.TICK;
                    }
                }
            }
        }
        return QuoteType.UNKNOWN;
    }

    @Override
    public DdfMessageType getMessageType() {
        return DdfMessageType.Market_DDF_20;
    }
}

