/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.messages;

import com.ddfplus.codec.Codec;
import com.ddfplus.enums.DdfMessageType;
import com.ddfplus.messages.AbstractMsgBaseMarket;
import com.ddfplus.messages.DdfTimestamp;
import com.ddfplus.util.DDFDate;
import java.time.ZonedDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CtrlTimestamp
extends AbstractMsgBaseMarket
implements DdfTimestamp {
    private static final Logger LOG = LoggerFactory.getLogger(CtrlTimestamp.class);
    protected volatile ZonedDateTime _dateTime = null;
    protected volatile int _year = 0;
    protected volatile int _month = 0;
    protected volatile int _date = 0;
    protected volatile int _hour = 0;
    protected volatile int _minute = 0;
    protected volatile int _second = 0;

    public CtrlTimestamp(byte[] message) {
        super(message);
    }

    @Override
    public int[] getTimeInParts() {
        return new int[]{this._year, this._month, this._date, this._hour, this._minute, this._second};
    }

    public static CtrlTimestamp Parse(byte[] array) {
        CtrlTimestamp message = new CtrlTimestamp(array);
        message._record = (char)35;
        message._subrecord = '\u0000';
        try {
            message._year = Codec.parseIntValue(array, 2, 4);
            message._month = Codec.parseIntValue(array, 6, 2) - 1;
            message._date = Codec.parseIntValue(array, 8, 2);
            message._hour = Codec.parseIntValue(array, 10, 2);
            message._minute = Codec.parseIntValue(array, 12, 2);
            message._second = Codec.parseIntValue(array, 14, 2);
            message._dateTime = ZonedDateTime.of(message._year, message._month + 1, message._date, message._hour, message._minute, message._second, 0, DDFDate._zoneChicago);
            message.millisCST = message._dateTime.toInstant().toEpochMilli();
            return message;
        }
        catch (Exception e) {
            LOG.error("Failed to parse time: " + new String(array) + ". ", (Throwable)e);
            return null;
        }
    }

    @Override
    public String toString() {
        return " TimeStamp : " + this._dateTime;
    }

    @Override
    public DdfMessageType getMessageType() {
        return DdfMessageType.Timestamp;
    }
}

