/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.messages;

import com.ddfplus.enums.QuoteType;
import com.ddfplus.messages.AbstractMsgBase;
import com.ddfplus.messages.DdfMarketBase;
import com.ddfplus.util.DDFDate;
import com.ddfplus.util.ParserHelper;
import java.time.ZonedDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMsgBaseMarket
extends AbstractMsgBase
implements DdfMarketBase {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMsgBaseMarket.class);
    public volatile char _basecode = '\u0000';
    public volatile char _day = '\u0000';
    public volatile int _delay = 0;
    public volatile int _etxpos = -1;
    public volatile char _exchange = '\u0000';
    public volatile char _record = '\u0000';
    public volatile char _session = '\u0000';
    public volatile String[] _spreadLegs = null;
    public volatile String _spreadType = null;
    public volatile char _subrecord = '\u0000';
    public volatile String _symbol = "";

    protected AbstractMsgBaseMarket(byte[] message) {
        super(message);
    }

    @Override
    public char getBaseCode() {
        return this._basecode;
    }

    @Override
    public char getDay() {
        return this._day;
    }

    @Override
    public int getDelay() {
        return this._delay;
    }

    @Override
    public int getPositionETX() {
        return this._etxpos;
    }

    @Override
    public char getExchange() {
        return this._exchange;
    }

    @Override
    public char getRecord() {
        return this._record;
    }

    @Override
    public char getSession() {
        return this._session;
    }

    @Override
    public char getSubRecord() {
        return this._subrecord;
    }

    @Override
    public String getSymbol() {
        return this._symbol;
    }

    protected void setBaseCode(char c) {
        this._basecode = c;
    }

    public void setMessageTimestamp(int etxpos) {
        if (this._message == null || this._message.length < etxpos + 1) {
            return;
        }
        this._etxpos = etxpos;
        if ((this._message.length == etxpos + 10 || this._message.length == etxpos + 8) && this._message[etxpos + 1] == 20) {
            int year = this._message[etxpos + 1] * 100 + this._message[etxpos + 2] - 64;
            int month = this._message[etxpos + 3] - 64 - 1;
            int date = this._message[etxpos + 4] - 64;
            int hour = this._message[etxpos + 5] - 64;
            int minute = this._message[etxpos + 6] - 64;
            int second = this._message[etxpos + 7] - 64;
            int ms = 0;
            if (this._message.length == etxpos + 10 && ((ms = (0xFF & this._message[etxpos + 8]) + ((0xFF & this._message[etxpos + 9]) << 8)) < 0 || ms > 999)) {
                ms = 0;
            }
            this.millisCST = ZonedDateTime.of(year, month + 1, date, hour, minute, second, ms * 1000000, DDFDate._zoneChicago).toInstant().toEpochMilli();
        }
    }

    public String toString() {
        StringBuilder text = new StringBuilder(128);
        text.append(" record=");
        text.append(ParserHelper.filterNullChar(this._record));
        text.append(" subrec=");
        text.append(ParserHelper.filterNullChar(this._subrecord));
        text.append(" exchcode=");
        text.append(ParserHelper.filterNullChar(this._exchange));
        if (this._symbol != "") {
            text.append(" sym=");
            text.append(this._symbol);
        }
        if (this._spreadLegs != null) {
            text.append(" legs=");
            text.append(this._spreadLegs);
        }
        text.append(" basecode=");
        text.append(ParserHelper.filterNullChar(this._basecode));
        text.append(" day=");
        text.append(ParserHelper.filterNullChar(this._day));
        this.appendConcrete(text);
        text.append(" [" + this.toStringAscii() + "]");
        return text.toString();
    }

    public String toStringHex() {
        return ParserHelper.toHexString(this._message);
    }

    public String toStringAscii() {
        return ParserHelper.toAsciiString(this._message);
    }

    public String toStringAsciiHex() {
        return "\n\t" + ParserHelper.toAsciiString2(this._message) + "\n\t" + ParserHelper.toHexString(this._message);
    }

    @Override
    public QuoteType getQuoteType() {
        return QuoteType.UNKNOWN;
    }
}

